/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pvcs_scm;

import hudson.model.AbstractBuild;
import hudson.plugins.pvcs_scm.PvcsChangeLogSet;
import hudson.plugins.pvcs_scm.changelog.ChangeLogDocument;
import hudson.plugins.pvcs_scm.changelog.PvcsChangeLogEntry;
import hudson.scm.ChangeLogParser;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.SAXException;

public class PvcsChangeLogParser
extends ChangeLogParser {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public PvcsChangeLogSet parse(AbstractBuild build, File changelogFile) throws IOException, SAXException {
        PvcsChangeLogSet clSet = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        this.logger.debug((Object)("parsing " + changelogFile));
        try {
            ChangeLogDocument doc = ChangeLogDocument.Factory.parse(changelogFile);
            clSet = new PvcsChangeLogSet(build);
            if (doc.getChangeLog().sizeOfEntryArray() > 0) {
                for (PvcsChangeLogEntry entry : doc.getChangeLog().getEntryArray()) {
                    PvcsChangeLogSet.Entry clEntry = clSet.addNewEntry(Collections.singleton(entry.getFileName()), entry.getUserName(), entry.getComment());
                    clEntry.setRevision(entry.getRevision());
                    clEntry.setModifiedTime(df.format(entry.getModifiedTime().getTime()));
                }
            }
        }
        catch (XmlException e) {
            this.logger.error((Object)String.format("Unable to parse %s: %s", changelogFile, e.getMessage()), (Throwable)e);
            throw new SAXException((Exception)((Object)e));
        }
        return clSet;
    }
}

