/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pwauth;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.pwauth.PWauthSecurityRealm;
import hudson.plugins.pwauth.PWauthValidation;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public final class PWauthDescriptor
extends Descriptor<SecurityRealm> {
    public PWauthDescriptor() {
        super(PWauthSecurityRealm.class);
        this.load();
    }

    public String getDisplayName() {
        return "PWauth Authentication";
    }

    public FormValidation doTest(@QueryParameter String pwauthPath, @QueryParameter String whitelist, @QueryParameter String grepPath, @QueryParameter String catPath, @QueryParameter String groupsPath, @QueryParameter String idPath) {
        if (!PWauthValidation.validatePath((String)pwauthPath)) {
            return FormValidation.error((String)"pwauth Path Invalid");
        }
        if (!PWauthValidation.validatePath((String)grepPath)) {
            return FormValidation.error((String)"grep Path Invalid");
        }
        if (!PWauthValidation.validatePath((String)catPath)) {
            return FormValidation.error((String)"cat Path Invalid");
        }
        if (!PWauthValidation.validatePath((String)groupsPath)) {
            return FormValidation.error((String)"groups Path Invalid");
        }
        if (!PWauthValidation.validatePath((String)idPath)) {
            return FormValidation.error((String)"id Path Invalid");
        }
        if (whitelist != null && !PWauthValidation.validateWhitelist((String)whitelist)) {
            return FormValidation.error((String)"IPs Invalid");
        }
        return FormValidation.ok((String)"Success");
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        this.save();
        return true;
    }
}

