/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pwauth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
class PWauthUtils {
    private static String pwAuthPath = "/usr/local/bin/pwauth";
    private static String idPath = "/usr/bin/id";
    private static String groupsPath = "/usr/bin/groups";
    private static String catPath = "/bin/cat";
    private static String grepPath = "/bin/grep";

    PWauthUtils() {
    }

    static boolean userExists(String username) throws IOException {
        Process p = Runtime.getRuntime().exec(idPath + " " + username);
        if (PWauthUtils.getProcessExitStatus((Process)p) != -1) {
            String result = new BufferedReader(new InputStreamReader(p.getInputStream())).readLine();
            return result != null && result.contains("uid=");
        }
        return false;
    }

    static boolean isUserValid(String username, String password) throws IOException {
        Process p = Runtime.getRuntime().exec(pwAuthPath);
        PrintWriter pw = new PrintWriter(p.getOutputStream());
        pw.write(username + System.getProperty("line.separator"));
        pw.write(password + System.getProperty("line.separator"));
        pw.flush();
        return PWauthUtils.getProcessExitStatus((Process)p) == 0;
    }

    static List<String> getUserGroups(String username) throws IOException {
        String result;
        Vector<String> groups = new Vector<String>();
        Process p = Runtime.getRuntime().exec(groupsPath + " " + username);
        if (PWauthUtils.getProcessExitStatus((Process)p) == 0 && (result = new BufferedReader(new InputStreamReader(p.getInputStream())).readLine()) != null) {
            result = result.substring(result.indexOf(":") + 1);
            for (String group : result.split("\\ ")) {
                if (group.trim().length() <= 0) continue;
                groups.add(group.trim());
            }
        }
        return groups;
    }

    static boolean groupExists(String group) {
        try {
            String cmd = String.format("%1$s /etc/group |%2$s %3$s:", catPath, grepPath, group);
            Process p = Runtime.getRuntime().exec(cmd);
            if (PWauthUtils.getProcessExitStatus((Process)p) == 0) {
                String result = new BufferedReader(new InputStreamReader(p.getInputStream())).readLine();
                return result.trim().length() > 0;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static int getProcessExitStatus(Process p) {
        int result = -1;
        boolean exited = false;
        while (!exited) {
            try {
                p.waitFor();
                result = p.exitValue();
                exited = true;
            }
            catch (Exception e) {
                exited = true;
            }
        }
        return result;
    }

    static void setPwAuthPath(String path) {
        if (path != null && !path.isEmpty()) {
            pwAuthPath = path.trim();
        }
    }

    public static final String getIdPath() {
        return idPath;
    }

    public static final void setIdPath(String path) {
        if (path != null && !path.isEmpty()) {
            idPath = path.trim();
        }
    }

    public static final String getGroupsPath() {
        return groupsPath;
    }

    public static final void setGroupsPath(String path) {
        if (path != null && !path.isEmpty()) {
            groupsPath = path.trim();
        }
    }

    public static final String getCatPath() {
        return catPath;
    }

    public static final void setCatPath(String path) {
        if (path != null && !path.isEmpty()) {
            catPath = path.trim();
        }
    }

    public static final String getGrepPath() {
        return grepPath;
    }

    public static final void setGrepPath(String path) {
        if (path != null && !path.isEmpty()) {
            grepPath = path.trim();
        }
    }

    public static final String getPwAuthPath() {
        return pwAuthPath;
    }
}

