/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pwauth;

import hudson.plugins.pwauth.PWauthAthenticationManager;
import hudson.plugins.pwauth.PWauthFilter;
import hudson.plugins.pwauth.PWauthUtils;
import hudson.plugins.pwauth.PWauthValidation;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.dao.DataAccessException;

public class PWauthSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    public final String pwauthPath;
    public final String whitelist;
    public final boolean enableParamAuth;
    public final String idPath;
    public final String groupsPath;
    public final String catPath;
    public final String grepPath;

    @DataBoundConstructor
    public PWauthSecurityRealm(String pwauthPath, String whitelist, boolean enableParamAuth, String idPath, String groupsPath, String catPath, String grepPath) {
        this.pwauthPath = pwauthPath;
        this.whitelist = whitelist;
        this.enableParamAuth = enableParamAuth;
        this.grepPath = grepPath;
        this.catPath = catPath;
        this.groupsPath = groupsPath;
        this.idPath = idPath;
        if (PWauthValidation.validatePath(pwauthPath)) {
            PWauthUtils.setPwAuthPath(pwauthPath);
        }
        if (PWauthValidation.validatePath(grepPath)) {
            PWauthUtils.setGrepPath(grepPath);
        }
        if (PWauthValidation.validatePath(catPath)) {
            PWauthUtils.setCatPath(catPath);
        }
        if (PWauthValidation.validatePath(groupsPath)) {
            PWauthUtils.setGroupsPath(groupsPath);
        }
        if (PWauthValidation.validatePath(idPath)) {
            PWauthUtils.setIdPath(idPath);
        }
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents((AuthenticationManager)new PWauthAthenticationManager(), new UserDetailsService(){

            public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
                try {
                    if (PWauthUtils.userExists(username)) {
                        return new User(username, "", true, true, true, true, new GrantedAuthority[]{SecurityRealm.AUTHENTICATED_AUTHORITY});
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new UsernameNotFoundException("No such Unix user: " + username);
            }
        });
    }

    public UserDetails authenticate(String username, String password) throws AuthenticationException {
        try {
            if (PWauthUtils.isUserValid(username, password)) {
                return new User(username, "", true, true, true, true, new GrantedAuthority[]{AUTHENTICATED_AUTHORITY});
            }
        }
        catch (Exception e) {
            throw new AuthenticationException("User could not be authenticated", e){
                private static final long serialVersionUID = 8636276439158457192L;
            };
        }
        return null;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        try {
            if (PWauthUtils.userExists(username)) {
                return new User(username, "", true, true, true, true, new GrantedAuthority[]{AUTHENTICATED_AUTHORITY});
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new UsernameNotFoundException("No such Unix user: " + username);
    }

    public GroupDetails loadGroupByGroupname(final String groupname) throws UsernameNotFoundException, DataAccessException {
        if (PWauthUtils.groupExists(groupname)) {
            throw new UsernameNotFoundException(groupname);
        }
        return new GroupDetails(){

            public String getName() {
                return groupname;
            }
        };
    }

    public Filter createFilter(FilterConfig filterConfig) {
        return new PWauthFilter(super.createFilter(filterConfig), this);
    }
}

