/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.plugins.pxe.BootConfiguration;
import hudson.plugins.pxe.ISO9660Tree;
import hudson.plugins.pxe.IsoBasedBootConfiguration;
import java.io.File;
import java.io.IOException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class IsoBasedBootConfiguration
extends BootConfiguration {
    public final File iso;
    private volatile String release;

    protected IsoBasedBootConfiguration(File iso) {
        this.iso = iso;
    }

    public String getRelease() {
        if (this.release == null) {
            try {
                this.release = this.getDescriptor().getReleaseInfo(this.iso);
            }
            catch (IOException e) {
                this.release = "Broken image at " + this.iso;
            }
        }
        return this.release;
    }

    public ISO9660Tree doImage() {
        return new ISO9660Tree(this.iso);
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.sendRedirect("./image/");
    }

    public String getDisplayName() {
        return this.getRelease();
    }

    public IsoBasedBootConfigurationDescriptor getDescriptor() {
        return (IsoBasedBootConfigurationDescriptor)super.getDescriptor();
    }
}

