/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.Util;
import hudson.plugins.pxe.Crypt;
import hudson.plugins.pxe.IsoBasedBootConfiguration;
import hudson.plugins.pxe.LinuxBootConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import org.jvnet.hudson.tftpd.Data;
import org.kohsuke.loopy.FileEntry;
import org.kohsuke.loopy.iso9660.ISO9660FileSystem;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerResponse;

public class RedHatBootCoonfiguration
extends LinuxBootConfiguration {
    public final String additionalPackages;
    public final String password;
    private static final Logger LOGGER = Logger.getLogger(RedHatBootCoonfiguration.class.getName());

    @DataBoundConstructor
    public RedHatBootCoonfiguration(File iso, String password, String additionalPackages) {
        super(iso);
        if (Util.fixEmptyAndTrim((String)password) == null) {
            password = "hudson";
        }
        if (!password.startsWith("$1$")) {
            password = Crypt.cryptMD5((String)"abcdefgh", (String)password);
        }
        this.password = password;
        this.additionalPackages = Util.fixEmptyAndTrim((String)additionalPackages);
    }

    protected String getIdSeed() {
        return this.getRelease().replaceAll("[ ()]", "");
    }

    protected FileEntry getTftpIsoMountDir(ISO9660FileSystem fs) throws IOException {
        return fs.get("/images/pxeboot");
    }

    public Data tftp(String fileName) throws IOException {
        if (fileName.equals("splash.jpg")) {
            ISO9660FileSystem fs = new ISO9660FileSystem(this.iso, false);
            return new IsoBasedBootConfiguration.FileEntryData(fs.grab("/isolinux/splash.jpg"));
        }
        return super.tftp(fileName);
    }

    public void doKickstart(StaplerResponse rsp) throws IOException {
        this.serveMacroExpandedResource(rsp, "kickstart.txt");
    }

    public String getPackageList() {
        if (this.additionalPackages == null) {
            return "# no additional packages";
        }
        return Util.join(Arrays.asList(this.additionalPackages.split(" +")), (String)"\n");
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

