/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.Util;
import hudson.model.Hudson;
import hudson.plugins.pxe.Crypt;
import hudson.plugins.pxe.LinuxBootConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.loopy.FileEntry;
import org.kohsuke.loopy.iso9660.ISO9660FileSystem;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerResponse;

public class UbuntuBootConfiguration
extends LinuxBootConfiguration {
    public final String additionalPackages;
    public final String userName;
    public final String password;
    private static final Logger LOGGER = Logger.getLogger(UbuntuBootConfiguration.class.getName());

    @DataBoundConstructor
    public UbuntuBootConfiguration(File iso, String userName, String password, String additionalPackages) {
        super(iso);
        if (Util.fixEmptyAndTrim((String)userName) == null) {
            userName = "hudson";
        }
        this.userName = userName;
        if (Util.fixEmptyAndTrim((String)password) == null) {
            password = "hudson";
        }
        if (!password.startsWith("$1$")) {
            password = Crypt.cryptMD5((String)"abcdefgh", (String)password);
        }
        this.password = password;
        this.additionalPackages = additionalPackages;
    }

    protected String getIdSeed() {
        Pattern p = Pattern.compile("Ubuntu[^ ]* ([0-9.]+).+?(i386|amd64)?");
        Matcher m = p.matcher(this.getRelease());
        if (m.find()) {
            if (m.group(2) != null) {
                return "ubuntu" + m.group(1) + '.' + m.group(2);
            }
            return "ubuntu" + m.group(1);
        }
        return "ubuntu";
    }

    protected FileEntry getTftpIsoMountDir(ISO9660FileSystem fs) throws IOException {
        FileEntry installer = fs.get("/install/netboot/ubuntu-installer");
        if (installer == null) {
            throw new IOException("/install/netboot/ubuntu-installer not found on " + this.iso);
        }
        LinkedHashMap children = installer.childEntries();
        FileEntry arch = (FileEntry)children.get("i386");
        if (arch == null) {
            arch = (FileEntry)children.get("amd64");
        }
        if (arch == null) {
            throw new IOException("/install/netboot/ubuntu-installer/(amd64|i386) not found on " + this.iso);
        }
        return arch;
    }

    public void doPreseed(StaplerResponse rsp) throws IOException {
        this.serveMacroExpandedResource(rsp, "preseed.txt");
    }

    public String getMirrorHostName() throws IOException {
        URL url = new URL(Hudson.getInstance().getRootUrl());
        if (url.getPort() != 80) {
            return url.getHost() + ':' + url.getPort();
        }
        return url.getHost();
    }

    public String getMirrorDirectory() throws IOException {
        URL url = new URL(Hudson.getInstance().getRootUrl());
        return url.getPath() + "pxe/" + this.getUrl() + "/image";
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

