/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.Util;
import hudson.plugins.pxe.IsoBasedBootConfiguration;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.context.HashMapContext;
import org.jvnet.hudson.tftpd.Data;
import org.kohsuke.loopy.FileEntry;
import org.kohsuke.loopy.iso9660.ISO9660FileSystem;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LinuxBootConfiguration
extends IsoBasedBootConfiguration {
    protected LinuxBootConfiguration(File iso) {
        super(iso);
    }

    @Override
    public String getPxeLinuxConfigFragment() throws IOException {
        return String.format("LABEL %1$s\n    MENU LABEL %2$s\n    KERNEL vesamenu.c32\n    APPEND %1$s/menu.txt \n", this.getId(), this.getRelease());
    }

    @Override
    public Data tftp(String fileName) throws IOException {
        FileEntry f;
        if (fileName.equals("menu.txt")) {
            String template = IOUtils.toString((InputStream)this.getResourceAsStream("menu.txt"));
            return Data.from((String)Util.replaceMacro((String)template, this.createResolver()));
        }
        ISO9660FileSystem fs = new ISO9660FileSystem(this.iso, false);
        FileEntry dir = this.getTftpIsoMountDir(fs);
        if (dir != null && (f = dir.get(fileName)) != null) {
            return new IsoBasedBootConfiguration.FileEntryData(f);
        }
        return null;
    }

    protected abstract FileEntry getTftpIsoMountDir(ISO9660FileSystem var1) throws IOException;

    protected VariableResolver<String> createResolver() {
        final HashMapContext context = new HashMapContext();
        context.put((Object)"it", (Object)this);
        context.put((Object)"timeZone", (Object)TimeZone.getDefault().getID());
        context.put((Object)"locale", (Object)Locale.getDefault().toString());
        return new VariableResolver<String>(){

            public String resolve(String name) {
                try {
                    if (context.containsKey((Object)name)) {
                        return context.get((Object)name).toString();
                    }
                    Object o = ExpressionFactory.createExpression((String)("it." + name)).evaluate((JexlContext)context);
                    if (o == null) {
                        return "";
                    }
                    return String.valueOf(o);
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
        };
    }

    protected void serveMacroExpandedResource(StaplerResponse rsp, String resourceName) throws IOException {
        rsp.setContentType("text/plain");
        rsp.getWriter().println(Util.replaceMacro((String)IOUtils.toString((InputStream)this.getResourceAsStream(resourceName)), this.createResolver()));
    }
}

