/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.plugins.pxe.DaemonService;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.logging.Logger;
import org.jvnet.hudson.proxy_dhcp.ProxyDhcpService;
import org.jvnet.hudson.tftpd.PathResolver;
import org.jvnet.hudson.tftpd.TFTPServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PXEBootProcess
implements Callable<DaemonService, IOException> {
    private final PathResolver resolver;
    private final String tftpAddress;
    private static final Logger LOGGER = Logger.getLogger(PXEBootProcess.class.getName());

    public PXEBootProcess(PathResolver resolver, String tftpAddress) {
        this.resolver = resolver;
        this.tftpAddress = tftpAddress;
    }

    public DaemonService call() throws IOException {
        LOGGER.info("Starting a DHCP proxy service");
        final Thread dhcp = this.start((Runnable)new ProxyDhcpService((Inet4Address)InetAddress.getByName(this.tftpAddress), "pxelinux.0"));
        LOGGER.info("Starting a TFTP service");
        final Thread tftp = this.start((Runnable)new TFTPServer(this.resolver));
        LOGGER.info("All services ready");
        return (DaemonService)Channel.current().export(DaemonService.class, (Object)new DaemonService(){

            public boolean isDHCPProxyAlive() {
                return dhcp.isAlive();
            }

            public boolean isTFTPAlive() {
                return tftp.isAlive();
            }
        });
    }

    private Thread start(Runnable task) {
        Thread t = new Thread(task);
        t.setDaemon(true);
        t.start();
        return t;
    }
}

