/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.Util;
import hudson.plugins.pxe.Crypt;
import hudson.plugins.pxe.IsoBasedBootConfiguration;
import hudson.plugins.pxe.LinuxBootConfiguration;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hudson.tftpd.Data;
import org.kohsuke.loopy.FileEntry;
import org.kohsuke.loopy.iso9660.ISO9660FileSystem;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerResponse;

public class RedHatBootCoonfiguration
extends LinuxBootConfiguration {
    public final String additionalPackages;
    public final String password;
    private static final Logger LOGGER = Logger.getLogger(RedHatBootCoonfiguration.class.getName());

    @DataBoundConstructor
    public RedHatBootCoonfiguration(File iso, String password, String additionalPackages) {
        super(iso);
        if (Util.fixEmptyAndTrim((String)password) == null) {
            password = "hudson";
        }
        if (!password.startsWith("$1$")) {
            password = Crypt.cryptMD5("abcdefgh", password);
        }
        this.password = password;
        this.additionalPackages = Util.fixEmptyAndTrim((String)additionalPackages);
    }

    protected String getIdSeed() {
        return this.getRelease().replaceAll("[ ()]", "");
    }

    protected FileEntry getTftpIsoMountDir(ISO9660FileSystem fs) throws IOException {
        return fs.get("/images/pxeboot");
    }

    public Data tftp(String fileName) throws IOException {
        if (fileName.equals("splash.jpg")) {
            ISO9660FileSystem fs = new ISO9660FileSystem(this.iso, false);
            return new IsoBasedBootConfiguration.FileEntryData(fs.grab("/isolinux/splash.jpg"));
        }
        return super.tftp(fileName);
    }

    public void doKickstart(StaplerResponse rsp) throws IOException {
        this.serveMacroExpandedResource(rsp, "kickstart.txt");
    }

    public String getPackageList() {
        if (this.additionalPackages == null) {
            return "# no additional packages";
        }
        return Util.join(Arrays.asList(this.additionalPackages.split(" +")), (String)"\n");
    }

    public static class DescriptorImpl
    extends IsoBasedBootConfiguration.IsoBasedBootConfigurationDescriptor {
        public String getDisplayName() {
            return "RedHat/Fedora";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String getReleaseInfo(File iso) throws IOException {
            ISO9660FileSystem fs = null;
            try {
                String string;
                try {
                    fs = new ISO9660FileSystem(iso, false);
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, iso + " isn't an ISO file?", e);
                    throw FormValidation.error((String)(iso + " doesn't look like an ISO file"));
                }
                FileEntry info = fs.get("/.treeinfo");
                if (info == null) {
                    throw FormValidation.error((String)(iso + " doesn't look like a RedHat/Fedora CD/DVD image"));
                }
                TreeMap<String, String> section = new TreeMap<String, String>();
                BufferedReader r = new BufferedReader(new InputStreamReader(info.read()));
                try {
                    String line;
                    while ((line = r.readLine()) != null) {
                        if (!line.contains(" = ")) continue;
                        String[] tokens = line.split("=");
                        section.put(tokens[0].trim(), tokens[1].trim());
                    }
                    if (!(section.containsKey("family") && section.containsKey("version") && section.containsKey("arch"))) {
                        throw FormValidation.error((String)(iso + " doesn't contain the name entry in media.repo"));
                    }
                    string = Util.join(Arrays.asList((String)section.get("family"), (String)section.get("version"), "(" + (String)section.get("arch") + ")"), (String)" ");
                }
                catch (Throwable throwable) {
                    r.close();
                    throw throwable;
                }
                r.close();
                return string;
            }
            finally {
                if (fs != null) {
                    fs.close();
                }
            }
        }
    }
}

