/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import org.kohsuke.loopy.FileEntry;
import org.kohsuke.loopy.iso9660.ISO9660FileSystem;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ISO9660Tree
implements HttpResponse {
    private final File iso;

    public ISO9660Tree(File iso) {
        this.iso = iso;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        ISO9660FileSystem fs = new ISO9660FileSystem(this.iso, false);
        try {
            String rest = req.getRestOfPath();
            FileEntry e = fs.get(rest);
            if (e == null) {
                rsp.sendError(404);
                return;
            }
            if (e.isDirectory()) {
                StringBuffer reqUrl = req.getRequestURL();
                if (reqUrl.charAt(reqUrl.length() - 1) != '/') {
                    rsp.sendRedirect2(reqUrl.append('/').toString());
                    return;
                }
                rsp.setContentType("text/html");
                PrintWriter w = new PrintWriter(rsp.getWriter());
                w.println("<html><body>");
                for (FileEntry f : e.childEntries().values()) {
                    w.printf("<LI><A HREF='%1$s%2$s'>%1$s%2$s</A></LI>", f.getName(), f.isDirectory() ? "/" : "");
                }
                w.println("</body></html>");
            } else {
                InputStream in = e.read();
                rsp.serveFile(req, in, e.getLastModifiedTime(), 1000000000L, e.getSize(), this.getMimeTypeName(e));
            }
        }
        finally {
            fs.close();
        }
    }

    private String getMimeTypeName(FileEntry e) {
        if (e.getName().endsWith(".rpm")) {
            return "mime-type:application/x-redhat-package-manager";
        }
        return e.getName();
    }
}

