/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.Util;
import hudson.model.Hudson;
import hudson.plugins.pxe.Crypt;
import hudson.plugins.pxe.IsoBasedBootConfiguration;
import hudson.plugins.pxe.PXE;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.jvnet.hudson.tftpd.Data;
import org.kohsuke.loopy.FileEntry;
import org.kohsuke.loopy.iso9660.ISO9660FileSystem;
import org.kohsuke.stapler.DataBoundConstructor;

public class OpenSolarisBootConfiguration
extends IsoBasedBootConfiguration {
    private transient AIWebServerThread aiServer;
    private static final Pattern RELEASE = Pattern.compile("title (.+)\n");
    private static final Logger LOGGER = Logger.getLogger(OpenSolarisBootConfiguration.class.getName());

    @DataBoundConstructor
    public OpenSolarisBootConfiguration(File iso) throws IOException {
        super(iso);
        this.startAIServer();
    }

    private void startAIServer() {
        try {
            this.aiServer = new AIWebServerThread();
            this.aiServer.start();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to restart the AI web server", e);
        }
    }

    private boolean isActive() {
        return PXE.get().getConfiguration(this.getId()) == this;
    }

    protected String getIdSeed() {
        Pattern p = Pattern.compile("snv_[^ ]+");
        Matcher m = p.matcher(this.getRelease());
        if (m.find()) {
            return m.group(0);
        }
        return "opensolaris";
    }

    protected void shutdown() throws IOException {
        if (this.aiServer != null) {
            this.aiServer.close();
        }
    }

    public String getPxeLinuxConfigFragment() throws IOException {
        String baseUrl = Hudson.getInstance().getRootUrl();
        String host = new URL(baseUrl).getHost();
        baseUrl = baseUrl.replace(host, InetAddress.getByName(host).getHostAddress());
        String httpIsoImage = String.format("%1$spxe/configuration/%2$s/image", baseUrl, this.getId());
        return String.format("LABEL %1$s\n    MENU LABEL %2$s\n    KERNEL mboot.c32\n    APPEND -solaris %1$s/boot/platform/i86pc/kernel/unix -v -m verbose -B install_media=%3$s,install_boot=%3$s/boot,livemode=text,install_service=dummy,install_svc_address=%4$s:%5$s --- %1$s/boot/boot_archive\n", this.getId(), this.getDisplayName(), httpIsoImage, host, this.aiServer.server.getLocalPort());
    }

    public Object readResolve() {
        this.startAIServer();
        return this;
    }

    public Data tftp(String fileName) throws IOException {
        ISO9660FileSystem fs = new ISO9660FileSystem(this.iso, false);
        return new IsoBasedBootConfiguration.FileEntryData(fs.getRootEntry().grab(fileName));
    }

    private class AIWebServerThread
    extends Thread {
        private final ServerSocket server;
        private boolean closed;

        public AIWebServerThread() throws IOException {
            super("OpenSolaris AI webserver for " + OpenSolarisBootConfiguration.this.iso);
            this.setDaemon(true);
            this.server = this.openSocket();
            LOGGER.info("OpenSolaris AI server for " + OpenSolarisBootConfiguration.this.iso + " started on port " + this.server.getLocalPort());
        }

        public void close() throws IOException {
            LOGGER.info("Shutting down " + this.getName());
            this.closed = true;
            this.server.close();
        }

        private ServerSocket openSocket() throws IOException {
            int preferred = Math.abs(OpenSolarisBootConfiguration.this.getIdSeed().hashCode()) % 40000 + 10000;
            try {
                return new ServerSocket(preferred);
            }
            catch (BindException e) {
                return new ServerSocket(0);
            }
        }

        public void run() {
            while (OpenSolarisBootConfiguration.this.isActive()) {
                Socket s;
                try {
                    s = this.server.accept();
                }
                catch (IOException e) {
                    if (!this.closed) {
                        LOGGER.log(Level.WARNING, "Failed to accept", e);
                    }
                    return;
                }
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            s.setSoTimeout(600000);
                            BufferedReader r = new BufferedReader(new InputStreamReader(s.getInputStream()));
                            PrintStream out = new PrintStream(s.getOutputStream());
                            String request = r.readLine();
                            if (request.startsWith("GET /manifest.xml")) {
                                out.println("HTTP/1.0 200 OK");
                                out.println("Content-Type: text/xml");
                                out.println("");
                                out.println("<CriteriaList>");
                                out.println("  <Version Number=\"0.5\"/>");
                                out.println("</CriteriaList>");
                            } else if (request.startsWith("POST /manifest.xml")) {
                                out.println("HTTP/1.0 200 OK");
                                out.println("Content-Type: text/xml");
                                out.println("");
                                String template = IOUtils.toString((InputStream)OpenSolarisBootConfiguration.this.getResourceAsStream("ai.xml"));
                                HashMap<String, String> props = new HashMap<String, String>();
                                props.put("userName", "jack");
                                props.put("rootPassword", Crypt.cryptMD5("abcdefgh", "opensolaris"));
                                props.put("timeZone", TimeZone.getDefault().getID());
                                out.println(Util.replaceMacro((String)template, props));
                            } else {
                                out.println("HTTP/1.0 404 Not Found");
                                out.println("Content-Type: text/html");
                                out.println("");
                                out.println("<html><body>This server only knows how to handle /manifest.xml</body></html>");
                            }
                            out.flush();
                            s.shutdownOutput();
                            IOUtils.toString((Reader)r);
                            s.shutdownInput();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, "Failed to serve a request from AI web server", e);
                        }
                        finally {
                            try {
                                s.close();
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.WARNING, "Failed to close a socket in AI web server", e);
                            }
                        }
                    }
                }.start();
            }
            LOGGER.fine(" AI web server thread exiting");
        }
    }

    public static class DescriptorImpl
    extends IsoBasedBootConfiguration.IsoBasedBootConfigurationDescriptor {
        public String getDisplayName() {
            return "OpenSolaris";
        }

        protected String getReleaseInfo(File iso) throws IOException {
            ISO9660FileSystem fs = null;
            try {
                try {
                    fs = new ISO9660FileSystem(iso, false);
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, iso + " isn't an ISO file?", e);
                    throw FormValidation.error((String)(iso + " doesn't look like an ISO file"));
                }
                if (fs.get("/solaris.zlib") == null || fs.get("/jack") == null) {
                    throw FormValidation.error((String)(iso + " doesn't look like an OpenSolaris CD image"));
                }
                FileEntry menu = fs.get("/boot/grub/menu.lst");
                if (menu == null) {
                    throw FormValidation.error((String)(iso + " doesn't look like an OpenSolaris CD image (no GRUB)"));
                }
                String menuList = IOUtils.toString((InputStream)menu.read());
                Matcher m = RELEASE.matcher(menuList);
                if (m.find()) {
                    String string = m.group(1);
                    return string;
                }
                throw FormValidation.error((String)(iso + " doesn't contain OpenSolaris grub menu"));
            }
            finally {
                if (fs != null) {
                    fs.close();
                }
            }
        }
    }
}

