/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.plugins.pxe.ZipBasedBootConfiguration;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jvnet.hudson.tftpd.Data;
import org.kohsuke.stapler.DataBoundConstructor;

public class PartedMagicConfiguration
extends ZipBasedBootConfiguration {
    @DataBoundConstructor
    public PartedMagicConfiguration(File zip) {
        super(zip);
    }

    protected String getIdSeed() {
        return "partedMagic";
    }

    public String getPxeLinuxConfigFragment() throws IOException {
        return String.format("LABEL %1$s\n    MENU LABEL %2$s\n    KERNEL %1$s/bzImage\n    APPEND initrd=%1$s/initramfs load_ramdisk=1 prompt_ramdisk=0 rw sleep=10\n", this.getId(), this.getRelease());
    }

    public Data tftp(String fileName) throws IOException {
        final ZipFile zip = new ZipFile(this.zip);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            final ZipEntry ze = e.nextElement();
            if (!ze.getName().endsWith('/' + fileName)) continue;
            return new Data(){

                public int size() throws IOException {
                    return (int)ze.getSize();
                }

                public InputStream read() throws IOException {
                    return zip.getInputStream(ze);
                }
            };
        }
        return null;
    }

    public static class DescriptorImpl
    extends ZipBasedBootConfiguration.ZipBasedBootConfigurationDescriptor {
        private static Pattern VERSION = Pattern.compile("pmagic-pxe-([0-9.]+)");

        public String getDisplayName() {
            return "Parted Magic";
        }

        protected String getReleaseInfo(ZipFile zip) throws IOException {
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                Matcher m = VERSION.matcher(ze.getName());
                if (!m.find()) continue;
                return "Parted Magic " + m.group(1);
            }
            throw FormValidation.error((String)(zip.getName() + " doesn't contain Parted Magic PXE files"));
        }
    }
}

