/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.BulkChange;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.os.SU;
import hudson.plugins.pxe.BootConfiguration;
import hudson.plugins.pxe.BootConfigurationDescriptor;
import hudson.plugins.pxe.DHCPPacketFilter;
import hudson.plugins.pxe.DaemonService;
import hudson.plugins.pxe.MacAddress;
import hudson.plugins.pxe.PXE;
import hudson.plugins.pxe.PXEBootProcess;
import hudson.plugins.pxe.PathResolverImpl;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tasks.Mailer;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.Secret;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.io.LargeText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PXE
extends ManagementLink
implements StaplerProxy,
Describable<PXE>,
Saveable {
    private String rootUserName;
    private Secret rootPassword;
    private final DescribableList<BootConfiguration, BootConfigurationDescriptor> bootConfigurations = new DescribableList((Saveable)this);
    private String tftpAddress;
    private transient VirtualChannel channel;
    private transient DaemonService daemonService;
    private boolean respondSelectively;
    private transient Set<MacAddress> approvedMacAddresses = new HashSet();
    private transient LinkedHashSet<MacAddress> discoveredMacAddresses = new LinkedHashSet();
    private static final Logger LOGGER = Logger.getLogger(PXE.class.getName());

    public PXE() throws IOException, InterruptedException {
        this.load();
        this.assignIDs();
        this.restartPXE();
    }

    public String getIconFileName() {
        return "orange-square.gif";
    }

    public String getDescription() {
        return "Simplify the slave installation by network installing them (AKA PXE boot)";
    }

    public String getUrlName() {
        return "pxe";
    }

    public String getDisplayName() {
        return "Network Slave Installation Management";
    }

    public String getRootUserName() {
        return this.rootUserName;
    }

    public Secret getRootPassword() {
        return this.rootPassword;
    }

    public DescribableList<BootConfiguration, BootConfigurationDescriptor> getBootConfigurations() {
        return this.bootConfigurations;
    }

    public void setTftpAddress(String address) throws IOException {
        this.tftpAddress = address;
        this.save();
    }

    public String getTftpAddress() {
        return this.tftpAddress;
    }

    public boolean isRespondSelectively() {
        return this.respondSelectively;
    }

    public boolean isRespondToAll() {
        return !this.respondSelectively;
    }

    public void setRespondSelectively(boolean respondSelectively) throws IOException {
        this.respondSelectively = respondSelectively;
        this.save();
    }

    public Set<MacAddress> getAddressesThatRequireApproval() {
        this.discoveredMacAddresses.removeAll(this.approvedMacAddresses);
        return Collections.unmodifiableSet(this.discoveredMacAddresses);
    }

    public VirtualChannel getChannel() {
        return this.channel;
    }

    public DaemonService getDaemonService() {
        return this.daemonService;
    }

    public File getLogFile() {
        return new File(Hudson.getInstance().getRootDir(), "pxe.log");
    }

    public synchronized void restartPXE() throws IOException, InterruptedException {
        if (Hudson.getInstance().getRootUrl() == null) {
            LOGGER.warning("Not starting TFTP/ProxyDHCP because Hudson Root URL is not configured");
            return;
        }
        if (this.tftpAddress == null) {
            LOGGER.warning("Not starting TFTP/ProxyDHCP service due to incomplete configuration");
            return;
        }
        if (this.channel != null) {
            LOGGER.info("Stopping TFTP/ProxyDHCP service");
            this.channel.close();
            this.channel.join(3000L);
        }
        LOGGER.info("Starting TFTP/ProxyDHCP service");
        StreamTaskListener listener = new StreamTaskListener(this.getLogFile());
        this.channel = SU.start((TaskListener)listener, (String)this.rootUserName, this.rootPassword == null ? null : this.rootPassword.toString());
        this.daemonService = (DaemonService)this.channel.call((Callable)new PXEBootProcess(new PathResolverImpl().export(this.channel), (DHCPPacketFilter)this.channel.export(DHCPPacketFilter.class, (Object)this.createDHCPPacketFilter()), this.tftpAddress));
    }

    private DHCPPacketFilter createDHCPPacketFilter() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setRootAccount(String userName, Secret password) throws IOException {
        this.rootUserName = Util.fixEmptyAndTrim((String)userName);
        this.rootPassword = password;
        this.save();
    }

    public FormValidation getDaemonStatus() {
        if (Mailer.descriptor().getUrl() == null) {
            return FormValidation.warningWithMarkup((String)"<a href='../configure'>Hudson Root URL is not configured</a>.");
        }
        DaemonService ds = this.getDaemonService();
        if (ds == null) {
            return FormValidation.warningWithMarkup((String)"PXE service is not yet started. <a href='console'>Check console for the status</a>");
        }
        if (!ds.isDHCPProxyAlive()) {
            return FormValidation.errorWithMarkup((String)"DHCP proxy service is failing. <a href='console'>Check console for the status</a>");
        }
        if (!ds.isTFTPAlive()) {
            return FormValidation.error((String)"TFTP service is failing");
        }
        return FormValidation.ok();
    }

    public Collection<BootConfigurationDescriptor> getDescriptors() {
        return BootConfiguration.all();
    }

    public BootConfiguration getConfiguration(String id) {
        for (BootConfiguration config : this.getBootConfigurations()) {
            if (!config.getId().equals(id)) continue;
            return config;
        }
        return null;
    }

    public Object getTarget() {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        return this;
    }

    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException, InterruptedException {
        JSONObject form = req.getSubmittedForm();
        BulkChange bc = new BulkChange((Saveable)this);
        try {
            this.setRootAccount(form.getString("rootUserName"), Secret.fromString((String)form.getString("rootPassword")));
            if (form.has("tftpAddress")) {
                this.setTftpAddress(form.getString("tftpAddress"));
            } else {
                this.setTftpAddress(((NIC)this.getNICs().get((int)0)).adrs.getHostAddress());
            }
            this.setRespondSelectively(!form.has("respondToAll"));
            for (BootConfiguration c : this.bootConfigurations) {
                c.shutdown();
            }
            this.bootConfigurations.rebuildHetero(req, form, this.getDescriptors(), "configuration");
            this.assignIDs();
        }
        catch (Descriptor.FormException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            bc.commit();
        }
        this.restartPXE();
        rsp.sendRedirect(".");
    }

    public void doDoApprove(StaplerRequest req, StaplerResponse rsp) throws ServletException, ParseException, IOException {
        String additional;
        JSONObject form = req.getSubmittedForm();
        if (form.has("mac")) {
            JSONObject j = form.getJSONObject("mac");
            for (String key : j.keySet()) {
                if (!j.getBoolean(key)) continue;
                this.approvedMacAddresses.add(new MacAddress(key));
            }
        }
        if ((additional = (String)form.get("additional")) != null) {
            for (String key : additional.split("\n")) {
                if ((key = key.trim()).length() <= 0) continue;
                this.approvedMacAddresses.add(new MacAddress(key));
            }
        }
        if (req.hasParameter("reset")) {
            this.approvedMacAddresses.clear();
        }
        rsp.sendRedirect(".");
    }

    private void assignIDs() {
        DescribableList all = this.getBootConfigurations();
        block0: for (BootConfiguration a : all) {
            String seed = a.getIdSeed();
            for (BootConfiguration b : all) {
                if (b == a || !b.getIdSeed().equals(seed)) continue;
                int index = 1;
                for (BootConfiguration c : all) {
                    if (c == a) {
                        a.id = seed + "_" + index;
                        continue block0;
                    }
                    if (!c.getIdSeed().equals(seed)) continue;
                    ++index;
                }
                throw new AssertionError();
            }
            a.id = seed;
        }
    }

    public void doProgressiveLog(StaplerRequest req, StaplerResponse rsp) throws IOException {
        new LargeText(this.getLogFile(), false).doProgressText(req, rsp);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public List<NIC> getNICs() throws SocketException {
        ArrayList<NIC> r = new ArrayList<NIC>();
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface ni = e.nextElement();
            Enumeration<InetAddress> adrs = ni.getInetAddresses();
            while (adrs.hasMoreElements()) {
                InetAddress a = adrs.nextElement();
                if (a.isLoopbackAddress() || !(a instanceof Inet4Address)) continue;
                r.add(new NIC(ni, (Inet4Address)a));
            }
        }
        return r;
    }

    protected void load() throws IOException {
        XmlFile xml = this.getConfigXml();
        if (xml.exists()) {
            xml.unmarshal((Object)this);
        }
    }

    public void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        this.getConfigXml().write((Object)this);
    }

    protected XmlFile getConfigXml() {
        return new XmlFile(Hudson.XSTREAM, new File(Hudson.getInstance().getRootDir(), "pxe.xml"));
    }

    public static PXE get() {
        return (PXE)ManagementLink.all().get(PXE.class);
    }

    static /* synthetic */ Set access$000(PXE x0) {
        return x0.approvedMacAddresses;
    }

    static /* synthetic */ LinkedHashSet access$100(PXE x0) {
        return x0.discoveredMacAddresses;
    }
}

