/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletException;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ZipTree
implements HttpResponse {
    private final File zip;

    public ZipTree(File zip) {
        this.zip = zip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        ZipFile zf = new ZipFile(this.zip);
        try {
            ZipEntry e;
            String rest = req.getRestOfPath().substring(1);
            if (!rest.endsWith("/")) {
                rest = rest + "/";
            }
            if ((e = zf.getEntry(rest)) == null) {
                e = zf.getEntry(rest.substring(0, rest.length() - 1));
            }
            if (e == null) {
                rsp.sendError(404);
                return;
            }
            if (e.isDirectory()) {
                StringBuffer reqUrl = req.getRequestURL();
                if (reqUrl.charAt(reqUrl.length() - 1) != '/') {
                    rsp.sendRedirect2(reqUrl.append('/').toString());
                    return;
                }
                rsp.setContentType("text/html");
                PrintWriter w = new PrintWriter(rsp.getWriter());
                w.println("<html><body>");
                Enumeration<? extends ZipEntry> list = zf.entries();
                while (list.hasMoreElements()) {
                    ZipEntry f = list.nextElement();
                    if (!f.getName().startsWith(e.getName())) continue;
                    w.printf("<LI><A HREF='%1$s'>%1$s</A></LI>", f.getName().substring(rest.length()));
                }
                w.println("</body></html>");
            } else {
                InputStream in = zf.getInputStream(e);
                rsp.serveFile(req, in, e.getTime(), 1000000000L, (int)e.getSize(), e.getName());
            }
        }
        finally {
            zf.close();
        }
    }
}

