/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.plugins.pxe.BootConfiguration;
import java.io.IOException;
import java.net.InetAddress;
import org.kohsuke.stapler.DataBoundConstructor;

public class ChainBootConfiguration
extends BootConfiguration {
    public final String hostName;
    public final String bootFile;

    @DataBoundConstructor
    public ChainBootConfiguration(String hostName, String bootFile) {
        this.hostName = hostName;
        this.bootFile = bootFile;
    }

    protected String getIdSeed() {
        return "chain";
    }

    public String getPxeLinuxConfigFragment() throws IOException {
        return String.format("LABEL %1$s\n    MENU LABEL Chainboot from %2$s\n    KERNEL pxechain.com\n    APPEND %3$s::%4$s \n", this.getId(), this.hostName, InetAddress.getByName(this.hostName).getHostAddress(), this.bootFile);
    }

    public String getDisplayName() {
        return "Chain boot from " + this.hostName + ":" + this.bootFile;
    }
}

