/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import java.text.ParseException;
import org.apache.commons.codec.binary.Hex;

public final class MacAddress {
    private final String id;

    public MacAddress(byte[] adrs) {
        String hex = new String(Hex.encodeHex((byte[])adrs)).substring(0, 12);
        this.id = this.reformat(hex);
    }

    private String reformat(String hex) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            if (buf.length() > 0) {
                buf.append(':');
            }
            buf.append(hex.substring(i * 2, i * 2 + 2));
        }
        return buf.toString().toUpperCase();
    }

    public MacAddress(String adrs) throws ParseException {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < adrs.length(); ++i) {
            char ch = Character.toUpperCase(adrs.charAt(i));
            if (('0' > ch || ch > '9') && ('A' > ch || ch > 'F')) continue;
            buf.append(ch);
        }
        if (buf.length() != 12) {
            throw new ParseException("Not a valid MAC address: " + adrs, 0);
        }
        this.id = this.reformat(buf.toString());
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MacAddress that = (MacAddress)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

