/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.model.Hudson;
import hudson.plugins.pxe.IsoBasedBootConfiguration;
import hudson.plugins.pxe.OpenSolarisBootConfiguration;
import hudson.plugins.pxe.PXE;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jvnet.hudson.tftpd.Data;
import org.kohsuke.loopy.iso9660.ISO9660FileSystem;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * Exception performing whole class analysis ignored.
 */
public class OpenSolarisBootConfiguration
extends IsoBasedBootConfiguration {
    private transient AIWebServerThread aiServer;
    private static final Pattern RELEASE = Pattern.compile("title (.+)\n");
    private static final Logger LOGGER = Logger.getLogger(OpenSolarisBootConfiguration.class.getName());

    @DataBoundConstructor
    public OpenSolarisBootConfiguration(File iso) throws IOException {
        super(iso);
        this.startAIServer();
    }

    private void startAIServer() {
        try {
            this.aiServer = new AIWebServerThread(this);
            this.aiServer.start();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to restart the AI web server", e);
        }
    }

    private boolean isActive() {
        return PXE.get().getConfiguration(this.getId()) == this;
    }

    protected String getIdSeed() {
        Pattern p = Pattern.compile("snv_[^ ]+");
        Matcher m = p.matcher(this.getRelease());
        if (m.find()) {
            return m.group(0);
        }
        return "opensolaris";
    }

    protected void shutdown() throws IOException {
        if (this.aiServer != null) {
            this.aiServer.close();
        }
    }

    public String getPxeLinuxConfigFragment() throws IOException {
        String baseUrl = Hudson.getInstance().getRootUrl();
        String host = new URL(baseUrl).getHost();
        baseUrl = baseUrl.replace(host, InetAddress.getByName(host).getHostAddress());
        String httpIsoImage = String.format("%1$spxe/configuration/%2$s/image", baseUrl, this.getId());
        return String.format("LABEL %1$s\n    MENU LABEL %2$s\n    KERNEL mboot.c32\n    APPEND -solaris %1$s/boot/platform/i86pc/kernel/unix -v -m verbose -B install_media=%3$s,install_boot=%3$s/boot,livemode=text,install_service=dummy,install_svc_address=%4$s:%5$s --- %1$s/boot/boot_archive\n", this.getId(), this.getDisplayName(), httpIsoImage, host, AIWebServerThread.access$000((AIWebServerThread)this.aiServer).getLocalPort());
    }

    public Object readResolve() {
        this.startAIServer();
        return this;
    }

    public Data tftp(String fileName) throws IOException {
        ISO9660FileSystem fs = new ISO9660FileSystem(this.iso, false);
        return new IsoBasedBootConfiguration.FileEntryData(fs.getRootEntry().grab(fileName));
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ Pattern access$200() {
        return RELEASE;
    }

    static /* synthetic */ boolean access$300(OpenSolarisBootConfiguration x0) {
        return x0.isActive();
    }
}

