/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.plugins.pxe.IsoBasedBootConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.jvnet.hudson.tftpd.Data;
import org.kohsuke.loopy.iso9660.ISO9660FileSystem;
import org.kohsuke.stapler.DataBoundConstructor;

public class VMWareESXiBootConfiguration
extends IsoBasedBootConfiguration {
    private static final Logger LOGGER = Logger.getLogger(VMWareESXiBootConfiguration.class.getName());

    @DataBoundConstructor
    public VMWareESXiBootConfiguration(File iso) {
        super(iso);
    }

    protected String getIdSeed() {
        return "esxi";
    }

    public Data tftp(String fileName) throws IOException {
        ISO9660FileSystem fs = new ISO9660FileSystem(this.iso, false);
        return new IsoBasedBootConfiguration.FileEntryData(fs.getRootEntry().grab(fileName));
    }

    public String getPxeLinuxConfigFragment() throws IOException {
        return String.format("LABEL %1$s\n    MENU LABEL %2$s\n    KERNEL mboot.c32\n    APPEND %3$s/vmkboot.gz --- %3$s/vmkernel.gz --- %3$s/sys.vgz --- %3$s/cim.vgz --- %3$s/ienviron.tgz --- %3$s/image.tgz --- %3$s/install.tgz\n", this.getId(), this.getDisplayName(), this.getId());
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

