/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.plugins.pxe.BootConfiguration;
import hudson.plugins.pxe.ZipBasedBootConfiguration;
import hudson.plugins.pxe.ZipTree;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class ZipBasedBootConfiguration
extends BootConfiguration {
    public final File zip;
    private volatile String release;

    protected ZipBasedBootConfiguration(File zip) {
        this.zip = zip;
    }

    public String getRelease() {
        if (this.release == null) {
            try {
                ZipFile zip = new ZipFile(this.zip);
                this.release = this.getDescriptor().getReleaseInfo(zip);
                zip.close();
            }
            catch (IOException e) {
                this.release = "Broken image at " + this.zip;
            }
        }
        return this.release;
    }

    public ZipTree doImage() {
        return new ZipTree(this.zip);
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.sendRedirect("./image/");
    }

    public String getDisplayName() {
        return this.getRelease();
    }

    public ZipBasedBootConfigurationDescriptor getDescriptor() {
        return (ZipBasedBootConfigurationDescriptor)super.getDescriptor();
    }
}

