/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.model.Hudson;
import hudson.plugins.pxe.BootConfiguration;
import hudson.plugins.pxe.BootConfigurationDescriptor;
import hudson.plugins.pxe.ISO9660Tree;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.jvnet.hudson.tftpd.Data;
import org.kohsuke.loopy.FileEntry;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class IsoBasedBootConfiguration
extends BootConfiguration {
    public final File iso;
    private volatile String release;

    protected IsoBasedBootConfiguration(File iso) {
        this.iso = iso;
    }

    public String getRelease() {
        if (this.release == null) {
            try {
                this.release = this.getDescriptor().getReleaseInfo(this.iso);
            }
            catch (IOException e) {
                this.release = "Broken image at " + this.iso;
            }
        }
        return this.release;
    }

    public ISO9660Tree doImage() {
        return new ISO9660Tree(this.iso);
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.sendRedirect("./image/");
    }

    public String getDisplayName() {
        return this.getRelease();
    }

    public IsoBasedBootConfigurationDescriptor getDescriptor() {
        return (IsoBasedBootConfigurationDescriptor)super.getDescriptor();
    }

    public static abstract class IsoBasedBootConfigurationDescriptor
    extends BootConfigurationDescriptor {
        public FormValidation doCheckIso(@QueryParameter String value) throws IOException {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (value.trim().length() == 0) {
                return FormValidation.ok();
            }
            File f = new File(value);
            if (!f.exists()) {
                return FormValidation.error((String)("No such file file exists: " + value));
            }
            try {
                return FormValidation.ok((String)this.getReleaseInfo(f));
            }
            catch (FormValidation e) {
                return e;
            }
        }

        protected abstract String getReleaseInfo(File var1) throws IOException;
    }

    protected static final class FileEntryData
    extends Data {
        private final FileEntry data;

        public FileEntryData(FileEntry entry) {
            this.data = entry;
        }

        public InputStream read() throws IOException {
            return this.data.read();
        }

        public int size() throws IOException {
            return this.data.getSize();
        }
    }
}

