/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.model.Hudson;
import hudson.plugins.pxe.BootConfiguration;
import hudson.plugins.pxe.BootConfigurationDescriptor;
import hudson.plugins.pxe.PXE;
import hudson.plugins.pxe.PathResolver2;
import hudson.remoting.Channel;
import hudson.remoting.RemoteInputStream;
import hudson.remoting.VirtualChannel;
import hudson.util.DescribableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.jvnet.hudson.tftpd.Data;
import org.jvnet.hudson.tftpd.PathResolver;

final class PathResolverImpl
implements PathResolver2,
Serializable {
    PathResolverImpl() {
    }

    public Data open(String fileName) throws IOException {
        DescribableList<BootConfiguration, BootConfigurationDescriptor> bootConfigurations = PXE.get().getBootConfigurations();
        for (BootConfiguration config : bootConfigurations) {
            Data d;
            String id = config.getId() + '/';
            if (!fileName.startsWith(id) || (d = config.tftp(fileName.substring(id.length()))) == null) continue;
            return d;
        }
        if (fileName.equals("pxelinux.cfg/default")) {
            StringBuilder buf = new StringBuilder(IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("tftp/" + fileName)));
            buf.append('\n');
            for (BootConfiguration conf : bootConfigurations) {
                buf.append(conf.getPxeLinuxConfigFragment()).append('\n');
            }
            return Data.from((String)buf.toString());
        }
        URL res = Hudson.getInstance().getPluginManager().uberClassLoader.getResource("tftp/" + fileName);
        if (res != null) {
            return Data.from((URL)res);
        }
        throw new IOException("No such file: " + fileName);
    }

    public int size(String path) throws IOException {
        return this.open(path).size();
    }

    public InputStream read(String path) throws IOException {
        return new RemoteInputStream(this.open(path).read());
    }

    private Object writeReplace() {
        return this.export((VirtualChannel)Channel.current());
    }

    public PathResolver export(VirtualChannel channel) {
        return new RemotePathResolverProxy((PathResolver2)channel.export(PathResolver2.class, (Object)this));
    }

    private static final class RemotePathResolverProxy
    implements PathResolver,
    Serializable {
        private final PathResolver2 proxy;
        private static final long serialVersionUID = 1L;

        private RemotePathResolverProxy(PathResolver2 proxy) {
            this.proxy = proxy;
        }

        public Data open(final String fileName) throws IOException {
            return new Data(){

                public InputStream read() throws IOException {
                    return RemotePathResolverProxy.this.proxy.read(fileName);
                }

                public int size() throws IOException {
                    return RemotePathResolverProxy.this.proxy.size(fileName);
                }
            };
        }
    }
}

