/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.Util;
import hudson.plugins.pxe.Crypt;
import hudson.plugins.pxe.IsoBasedBootConfiguration;
import hudson.plugins.pxe.LinuxBootConfiguration;
import hudson.util.FormValidation;
import hudson.util.NullStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.kohsuke.loopy.FileEntry;
import org.kohsuke.loopy.iso9660.ISO9660FileSystem;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerResponse;

public class UbuntuBootConfiguration
extends LinuxBootConfiguration {
    public final String additionalPackages;
    public final String userName;
    public final String password;
    public final String lateCommand;
    public final String customMirror;
    public final String userContent;
    private static final Logger LOGGER = Logger.getLogger(UbuntuBootConfiguration.class.getName());

    @DataBoundConstructor
    public UbuntuBootConfiguration(File iso, String userName, String password, String additionalPackages, String lateCommand, String customMirror, String userContent) {
        super(iso);
        if (Util.fixEmptyAndTrim((String)userName) == null) {
            userName = "hudson";
        }
        this.userName = userName;
        if (Util.fixEmptyAndTrim((String)password) == null) {
            password = "hudson";
        }
        if (!password.startsWith("$1$")) {
            password = Crypt.cryptMD5("abcdefgh", password);
        }
        this.password = password;
        this.additionalPackages = additionalPackages;
        if (lateCommand != null && !lateCommand.startsWith("#!")) {
            lateCommand = "#!/bin/bash\n" + lateCommand;
        }
        this.lateCommand = lateCommand;
        this.customMirror = Util.fixEmpty((String)customMirror);
        this.userContent = Util.fixEmpty((String)userContent);
    }

    protected String getIdSeed() {
        Pattern p = Pattern.compile("Ubuntu[^ ]* ([0-9.]+).+?(i386|amd64)?");
        Matcher m = p.matcher(this.getRelease());
        if (m.find()) {
            if (m.group(2) != null) {
                return "ubuntu" + m.group(1) + '.' + m.group(2);
            }
            return "ubuntu" + m.group(1);
        }
        return "ubuntu";
    }

    protected FileEntry getTftpIsoMountDir(ISO9660FileSystem fs) throws IOException {
        FileEntry installer = fs.get("/install/netboot/ubuntu-installer");
        if (installer == null) {
            throw new IOException("/install/netboot/ubuntu-installer not found on " + this.iso);
        }
        LinkedHashMap children = installer.childEntries();
        FileEntry arch = (FileEntry)children.get("i386");
        if (arch == null) {
            arch = (FileEntry)children.get("amd64");
        }
        if (arch == null) {
            throw new IOException("/install/netboot/ubuntu-installer/(amd64|i386) not found on " + this.iso);
        }
        return arch;
    }

    public void doPreseed(StaplerResponse rsp) throws IOException {
        this.serveMacroExpandedResource(rsp, "preseed.txt");
    }

    public String getMirrorHostName() throws IOException {
        URL url = this.getMirrorUrl();
        if (url.getPort() != 80 && url.getPort() != -1) {
            return url.getHost() + ':' + url.getPort();
        }
        return url.getHost();
    }

    public String getMirrorDirectory() throws IOException {
        return this.getMirrorUrl().getPath();
    }

    private URL getMirrorUrl() throws MalformedURLException {
        return new URL(this.customMirror != null ? this.customMirror : this.getAbsoluteUrl() + "/image");
    }

    public void doLateCommand(StaplerResponse rsp) throws IOException {
        rsp.setContentType("text/plain;charset=UTF-8");
        PrintWriter w = rsp.getWriter();
        w.print(Util.fixNull((String)this.lateCommand));
        w.close();
    }

    public static class DescriptorImpl
    extends IsoBasedBootConfiguration.IsoBasedBootConfigurationDescriptor {
        public String getDisplayName() {
            return "Ubuntu";
        }

        public FormValidation doCheckCustomMirror(@QueryParameter String value) {
            try {
                value = Util.fixEmptyAndTrim((String)value);
                if (value == null) {
                    return FormValidation.ok();
                }
                IOUtils.copy((InputStream)new URL(value).openStream(), (OutputStream)new NullStream());
                return FormValidation.ok();
            }
            catch (IOException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String getReleaseInfo(File iso) throws IOException {
            ISO9660FileSystem fs = null;
            try {
                try {
                    fs = new ISO9660FileSystem(iso, false);
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, iso + " isn't an ISO file?", e);
                    throw FormValidation.error((String)(iso + " doesn't look like an ISO file"));
                }
                FileEntry info = fs.get("/.disk/info");
                if (info == null) {
                    throw FormValidation.error((String)(iso + " doesn't look like an Ubuntu CD/DVD image"));
                }
                FileEntry installer = fs.get("/install/netboot/ubuntu-installer");
                if (installer == null) {
                    throw FormValidation.error((String)(iso + " doesn't have the network boot installer in it. Perhaps it's a desktop CD?"));
                }
                String string = IOUtils.toString((InputStream)info.read());
                return string;
            }
            finally {
                if (fs != null) {
                    fs.close();
                }
            }
        }
    }
}

