/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.plugins.pxe.IsoBasedBootConfiguration;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hudson.tftpd.Data;
import org.kohsuke.loopy.iso9660.ISO9660FileSystem;
import org.kohsuke.stapler.DataBoundConstructor;

public class VMWareESXiBootConfiguration
extends IsoBasedBootConfiguration {
    private static final Logger LOGGER = Logger.getLogger(VMWareESXiBootConfiguration.class.getName());

    @DataBoundConstructor
    public VMWareESXiBootConfiguration(File iso) {
        super(iso);
    }

    protected String getIdSeed() {
        return "esxi";
    }

    public Data tftp(String fileName) throws IOException {
        ISO9660FileSystem fs = new ISO9660FileSystem(this.iso, false);
        return new IsoBasedBootConfiguration.FileEntryData(fs.getRootEntry().grab(fileName));
    }

    public String getPxeLinuxConfigFragment() throws IOException {
        return String.format("LABEL %1$s\n    MENU LABEL %2$s\n    KERNEL mboot.c32\n    APPEND %3$s/vmkboot.gz --- %3$s/vmkernel.gz --- %3$s/sys.vgz --- %3$s/cim.vgz --- %3$s/ienviron.tgz --- %3$s/image.tgz --- %3$s/install.tgz\n", this.getId(), this.getDisplayName(), this.getId());
    }

    public static class DescriptorImpl
    extends IsoBasedBootConfiguration.IsoBasedBootConfigurationDescriptor {
        public String getDisplayName() {
            return "VMWare ESXi";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String getReleaseInfo(File iso) throws IOException {
            ISO9660FileSystem fs = null;
            try {
                try {
                    fs = new ISO9660FileSystem(iso, false);
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, iso + " isn't an ISO file?", e);
                    throw FormValidation.error((String)(iso + " doesn't look like an ISO file"));
                }
                if (fs.get("/cim.vgz") == null || fs.get("/vmkboot.gz") == null) {
                    throw FormValidation.error((String)(iso + " doesn't look like an ESXi CD image"));
                }
                String string = "VMWare ESXi";
                return string;
            }
            finally {
                if (fs != null) {
                    fs.close();
                }
            }
        }
    }
}

