/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pxe;

import hudson.model.Hudson;
import hudson.plugins.pxe.BootConfiguration;
import hudson.plugins.pxe.BootConfigurationDescriptor;
import hudson.plugins.pxe.ZipTree;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class ZipBasedBootConfiguration
extends BootConfiguration {
    public final File zip;
    private volatile String release;

    protected ZipBasedBootConfiguration(File zip) {
        this.zip = zip;
    }

    public String getRelease() {
        if (this.release == null) {
            try {
                ZipFile zip = new ZipFile(this.zip);
                this.release = this.getDescriptor().getReleaseInfo(zip);
                zip.close();
            }
            catch (IOException e) {
                this.release = "Broken image at " + this.zip;
            }
        }
        return this.release;
    }

    public ZipTree doImage() {
        return new ZipTree(this.zip);
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.sendRedirect("./image/");
    }

    public String getDisplayName() {
        return this.getRelease();
    }

    public ZipBasedBootConfigurationDescriptor getDescriptor() {
        return (ZipBasedBootConfigurationDescriptor)super.getDescriptor();
    }

    public static abstract class ZipBasedBootConfigurationDescriptor
    extends BootConfigurationDescriptor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormValidation doCheckZip(@QueryParameter String value) throws IOException {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (value.trim().length() == 0) {
                return FormValidation.ok();
            }
            File f = new File(value);
            if (!f.exists()) {
                return FormValidation.error((String)("No such file file exists: " + value));
            }
            ZipFile zip = null;
            try {
                try {
                    zip = new ZipFile(f);
                }
                catch (IOException e) {
                    FormValidation formValidation = FormValidation.error((String)(value + " doesn't look like a valid zip file"));
                    if (zip != null) {
                        zip.close();
                    }
                    return formValidation;
                }
                FormValidation e = FormValidation.ok((String)this.getReleaseInfo(zip));
                return e;
            }
            finally {
                if (zip != null) {
                    zip.close();
                }
            }
        }

        protected abstract String getReleaseInfo(ZipFile var1) throws IOException;
    }
}

