// CHECKSTYLE:OFF

package com.michelin.cio.hudson.plugins.qc;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * No Quality Center installation found
     * 
     */
    public static String QualityCenter_NoInstallationSet() {
        return holder.format("QualityCenter.NoInstallationSet");
    }

    /**
     * No Quality Center installation found
     * 
     */
    public static Localizable _QualityCenter_NoInstallationSet() {
        return new Localizable(holder, "QualityCenter.NoInstallationSet");
    }

    /**
     * Couldn''t find a valid version of QuickTest Professional Add-in
     * 
     */
    public static String QualityCenterQTPAddinsInstaller_CouldntFindValidVersion() {
        return holder.format("QualityCenterQTPAddinsInstaller.CouldntFindValidVersion");
    }

    /**
     * Couldn''t find a valid version of QuickTest Professional Add-in
     * 
     */
    public static Localizable _QualityCenterQTPAddinsInstaller_CouldntFindValidVersion() {
        return new Localizable(holder, "QualityCenterQTPAddinsInstaller.CouldntFindValidVersion");
    }

    /**
     * Server URL must be defined
     * 
     */
    public static String QualityCenter_ServerURLMustBeDefined() {
        return holder.format("QualityCenter.ServerURLMustBeDefined");
    }

    /**
     * Server URL must be defined
     * 
     */
    public static Localizable _QualityCenter_ServerURLMustBeDefined() {
        return new Localizable(holder, "QualityCenter.ServerURLMustBeDefined");
    }

    /**
     * QuickTest Professional Add-in installation succeeded
     * 
     */
    public static String QualityCenterQTPAddinsInstaller_InstallationSuccessfull() {
        return holder.format("QualityCenterQTPAddinsInstaller.InstallationSuccessfull");
    }

    /**
     * QuickTest Professional Add-in installation succeeded
     * 
     */
    public static Localizable _QualityCenterQTPAddinsInstaller_InstallationSuccessfull() {
        return new Localizable(holder, "QualityCenterQTPAddinsInstaller.InstallationSuccessfull");
    }

    /**
     * Generating silent install script for QuickTest Professional Add-in...
     * 
     */
    public static String QualityCenterQTPAddinsInstaller_GeneratingInstallerISS() {
        return holder.format("QualityCenterQTPAddinsInstaller.GeneratingInstallerISS");
    }

    /**
     * Generating silent install script for QuickTest Professional Add-in...
     * 
     */
    public static Localizable _QualityCenterQTPAddinsInstaller_GeneratingInstallerISS() {
        return new Localizable(holder, "QualityCenterQTPAddinsInstaller.GeneratingInstallerISS");
    }

    /**
     * This is not a Quality Center client directory
     * 
     */
    public static String QualityCenterInstallation_NotQualityCenterDir() {
        return holder.format("QualityCenterInstallation.NotQualityCenterDir");
    }

    /**
     * This is not a Quality Center client directory
     * 
     */
    public static Localizable _QualityCenterInstallation_NotQualityCenterDir() {
        return new Localizable(holder, "QualityCenterInstallation.NotQualityCenterDir");
    }

    /**
     * No HP Quality Center build step have been defined for this job: Nothing to do!
     * 
     */
    public static String QualityCenterResultArchiver_NoBuilderSet() {
        return holder.format("QualityCenterResultArchiver.NoBuilderSet");
    }

    /**
     * No HP Quality Center build step have been defined for this job: Nothing to do!
     * 
     */
    public static Localizable _QualityCenterResultArchiver_NoBuilderSet() {
        return new Localizable(holder, "QualityCenterResultArchiver.NoBuilderSet");
    }

    /**
     * QuickTest Professional Add-in
     * 
     */
    public static String QualityCenterQTPAddinsInstallation_DisplayName() {
        return holder.format("QualityCenterQTPAddinsInstallation.DisplayName");
    }

    /**
     * QuickTest Professional Add-in
     * 
     */
    public static Localizable _QualityCenterQTPAddinsInstallation_DisplayName() {
        return new Localizable(holder, "QualityCenterQTPAddinsInstallation.DisplayName");
    }

    /**
     * You must agree to the QuickTest Professional Add-in license agreement
     * 
     */
    public static String QualityCenterQTPAddinsInstaller_AcceptLicense() {
        return holder.format("QualityCenterQTPAddinsInstaller.AcceptLicense");
    }

    /**
     * You must agree to the QuickTest Professional Add-in license agreement
     * 
     */
    public static Localizable _QualityCenterQTPAddinsInstaller_AcceptLicense() {
        return new Localizable(holder, "QualityCenterQTPAddinsInstaller.AcceptLicense");
    }

    /**
     * Quality Center client installation succeeded
     * 
     */
    public static String QualityCenterClientInstaller_InstallationSuccessfull() {
        return holder.format("QualityCenterClientInstaller.InstallationSuccessfull");
    }

    /**
     * Quality Center client installation succeeded
     * 
     */
    public static Localizable _QualityCenterClientInstaller_InstallationSuccessfull() {
        return new Localizable(holder, "QualityCenterClientInstaller.InstallationSuccessfull");
    }

    /**
     * The path must be defined
     * 
     */
    public static String QualityCenter_PathMustBeDefined() {
        return holder.format("QualityCenter.PathMustBeDefined");
    }

    /**
     * The path must be defined
     * 
     */
    public static Localizable _QualityCenter_PathMustBeDefined() {
        return new Localizable(holder, "QualityCenter.PathMustBeDefined");
    }

    /**
     * Tests report not generated
     * 
     */
    public static String QualityCenter_ReportNotGenerated() {
        return holder.format("QualityCenter.ReportNotGenerated");
    }

    /**
     * Tests report not generated
     * 
     */
    public static Localizable _QualityCenter_ReportNotGenerated() {
        return new Localizable(holder, "QualityCenter.ReportNotGenerated");
    }

    /**
     * TestSet folder should be defined
     * 
     */
    public static String QualityCenter_TSFolderShouldBeDefined() {
        return holder.format("QualityCenter.TSFolderShouldBeDefined");
    }

    /**
     * TestSet folder should be defined
     * 
     */
    public static Localizable _QualityCenter_TSFolderShouldBeDefined() {
        return new Localizable(holder, "QualityCenter.TSFolderShouldBeDefined");
    }

    /**
     * Cannot find installer on disk
     * 
     */
    public static String QualityCenterClientInstaller_CannotFindInstaller() {
        return holder.format("QualityCenterClientInstaller.CannotFindInstaller");
    }

    /**
     * Cannot find installer on disk
     * 
     */
    public static Localizable _QualityCenterClientInstaller_CannotFindInstaller() {
        return new Localizable(holder, "QualityCenterClientInstaller.CannotFindInstaller");
    }

    /**
     * Publish Quality Center tests results
     * 
     */
    public static String QualityCenterResultArchiver_DisplayName() {
        return holder.format("QualityCenterResultArchiver.DisplayName");
    }

    /**
     * Publish Quality Center tests results
     * 
     */
    public static Localizable _QualityCenterResultArchiver_DisplayName() {
        return new Localizable(holder, "QualityCenterResultArchiver.DisplayName");
    }

    /**
     * Couldn''t find DLL {0} after installation. Already installed somewhere else?
     * 
     */
    public static String QualityCenterClientInstaller_CouldntFindDllAfterInstall(Object arg1) {
        return holder.format("QualityCenterClientInstaller.CouldntFindDllAfterInstall", arg1);
    }

    /**
     * Couldn''t find DLL {0} after installation. Already installed somewhere else?
     * 
     */
    public static Localizable _QualityCenterClientInstaller_CouldntFindDllAfterInstall(Object arg1) {
        return new Localizable(holder, "QualityCenterClientInstaller.CouldntFindDllAfterInstall", arg1);
    }

    /**
     * Domain should be defined
     * 
     */
    public static String QualityCenter_DomainShouldBeDefined() {
        return holder.format("QualityCenter.DomainShouldBeDefined");
    }

    /**
     * Domain should be defined
     * 
     */
    public static Localizable _QualityCenter_DomainShouldBeDefined() {
        return new Localizable(holder, "QualityCenter.DomainShouldBeDefined");
    }

    /**
     * Couldn''t find required DLL
     * 
     */
    public static String QualityCenter_DllNotFound() {
        return holder.format("QualityCenter.DllNotFound");
    }

    /**
     * Couldn''t find required DLL
     * 
     */
    public static Localizable _QualityCenter_DllNotFound() {
        return new Localizable(holder, "QualityCenter.DllNotFound");
    }

    /**
     * This can''t be used on this operating system (only Windows is supported)
     * 
     */
    public static String QualityCenter_NotAvailableOnThisOS() {
        return holder.format("QualityCenter.NotAvailableOnThisOS");
    }

    /**
     * This can''t be used on this operating system (only Windows is supported)
     * 
     */
    public static Localizable _QualityCenter_NotAvailableOnThisOS() {
        return new Localizable(holder, "QualityCenter.NotAvailableOnThisOS");
    }

    /**
     * Malformed server URL
     * 
     */
    public static String QualityCenter_MalformedServerURL() {
        return holder.format("QualityCenter.MalformedServerURL");
    }

    /**
     * Malformed server URL
     * 
     */
    public static Localizable _QualityCenter_MalformedServerURL() {
        return new Localizable(holder, "QualityCenter.MalformedServerURL");
    }

    /**
     * This is not a directory
     * 
     */
    public static String QualityCenterInstallation_NotADirectory() {
        return holder.format("QualityCenterInstallation.NotADirectory");
    }

    /**
     * This is not a directory
     * 
     */
    public static Localizable _QualityCenterInstallation_NotADirectory() {
        return new Localizable(holder, "QualityCenterInstallation.NotADirectory");
    }

    /**
     * Path must include installer file name
     * 
     */
    public static String QualityCenterClientInstaller_ShouldBeAFile() {
        return holder.format("QualityCenterClientInstaller.ShouldBeAFile");
    }

    /**
     * Path must include installer file name
     * 
     */
    public static Localizable _QualityCenterClientInstaller_ShouldBeAFile() {
        return new Localizable(holder, "QualityCenterClientInstaller.ShouldBeAFile");
    }

    /**
     * Couldn''t run tests
     * 
     */
    public static String QualityCenter_TSSchedulerFailed() {
        return holder.format("QualityCenter.TSSchedulerFailed");
    }

    /**
     * Couldn''t run tests
     * 
     */
    public static Localizable _QualityCenter_TSSchedulerFailed() {
        return new Localizable(holder, "QualityCenter.TSSchedulerFailed");
    }

    /**
     * Couldn''t find report reader {0} after install
     * 
     */
    public static String QualityCenterQTPAddinsInstaller_CouldntFindExeAfterInstall(Object arg1) {
        return holder.format("QualityCenterQTPAddinsInstaller.CouldntFindExeAfterInstall", arg1);
    }

    /**
     * Couldn''t find report reader {0} after install
     * 
     */
    public static Localizable _QualityCenterQTPAddinsInstaller_CouldntFindExeAfterInstall(Object arg1) {
        return new Localizable(holder, "QualityCenterQTPAddinsInstaller.CouldntFindExeAfterInstall", arg1);
    }

    /**
     * Downloading {0}...
     * 
     */
    public static String QualityCenterClientInstaller_Downloading(Object arg1) {
        return holder.format("QualityCenterClientInstaller.Downloading", arg1);
    }

    /**
     * Downloading {0}...
     * 
     */
    public static Localizable _QualityCenterClientInstaller_Downloading(Object arg1) {
        return new Localizable(holder, "QualityCenterClientInstaller.Downloading", arg1);
    }

    /**
     * Quality Center client
     * 
     */
    public static String QualityCenterInstallation_DisplayName() {
        return holder.format("QualityCenterInstallation.DisplayName");
    }

    /**
     * Quality Center client
     * 
     */
    public static Localizable _QualityCenterInstallation_DisplayName() {
        return new Localizable(holder, "QualityCenterInstallation.DisplayName");
    }

    /**
     * Username should be defined
     * 
     */
    public static String QualityCenter_UsernameShouldBeDefined() {
        return holder.format("QualityCenter.UsernameShouldBeDefined");
    }

    /**
     * Username should be defined
     * 
     */
    public static Localizable _QualityCenter_UsernameShouldBeDefined() {
        return new Localizable(holder, "QualityCenter.UsernameShouldBeDefined");
    }

    /**
     * HP Quality Center
     * 
     */
    public static String QualityCenter_DisplayName() {
        return holder.format("QualityCenter.DisplayName");
    }

    /**
     * HP Quality Center
     * 
     */
    public static Localizable _QualityCenter_DisplayName() {
        return new Localizable(holder, "QualityCenter.DisplayName");
    }

    /**
     * Copying installer from master server {0}...
     * 
     */
    public static String QualityCenterClientInstaller_CopyingFromMaster(Object arg1) {
        return holder.format("QualityCenterClientInstaller.CopyingFromMaster", arg1);
    }

    /**
     * Copying installer from master server {0}...
     * 
     */
    public static Localizable _QualityCenterClientInstaller_CopyingFromMaster(Object arg1) {
        return new Localizable(holder, "QualityCenterClientInstaller.CopyingFromMaster", arg1);
    }

    /**
     * Project name should be defined
     * 
     */
    public static String QualityCenter_ProjectShouldBeDefined() {
        return holder.format("QualityCenter.ProjectShouldBeDefined");
    }

    /**
     * Project name should be defined
     * 
     */
    public static Localizable _QualityCenter_ProjectShouldBeDefined() {
        return new Localizable(holder, "QualityCenter.ProjectShouldBeDefined");
    }

    /**
     * TestSet name should be defined
     * 
     */
    public static String QualityCenter_TSNameShouldBeDefined() {
        return holder.format("QualityCenter.TSNameShouldBeDefined");
    }

    /**
     * TestSet name should be defined
     * 
     */
    public static Localizable _QualityCenter_TSNameShouldBeDefined() {
        return new Localizable(holder, "QualityCenter.TSNameShouldBeDefined");
    }

    /**
     * QuickTest Professional Add-in for Quality Center
     * 
     */
    public static String QualityCenterQTPAddinsInstaller_DescriptorImpl_DisplayName() {
        return holder.format("QualityCenterQTPAddinsInstaller.DescriptorImpl.DisplayName");
    }

    /**
     * QuickTest Professional Add-in for Quality Center
     * 
     */
    public static Localizable _QualityCenterQTPAddinsInstaller_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "QualityCenterQTPAddinsInstaller.DescriptorImpl.DisplayName");
    }

    /**
     * Couldn''t find VBScript used to run tests
     * 
     */
    public static String QualityCenter_VBSNotFound() {
        return holder.format("QualityCenter.VBSNotFound");
    }

    /**
     * Couldn''t find VBScript used to run tests
     * 
     */
    public static Localizable _QualityCenter_VBSNotFound() {
        return new Localizable(holder, "QualityCenter.VBSNotFound");
    }

    /**
     * Error when trying to open connection to QC server
     * 
     */
    public static String QualityCenter_ErrorOpeningServerConnection() {
        return holder.format("QualityCenter.ErrorOpeningServerConnection");
    }

    /**
     * Error when trying to open connection to QC server
     * 
     */
    public static Localizable _QualityCenter_ErrorOpeningServerConnection() {
        return new Localizable(holder, "QualityCenter.ErrorOpeningServerConnection");
    }

    /**
     * Couldn''t generate silent install script
     * 
     */
    public static String QualityCenterQTPAddinsInstaller_CouldntGenerateInstallerISS() {
        return holder.format("QualityCenterQTPAddinsInstaller.CouldntGenerateInstallerISS");
    }

    /**
     * Couldn''t generate silent install script
     * 
     */
    public static Localizable _QualityCenterQTPAddinsInstaller_CouldntGenerateInstallerISS() {
        return new Localizable(holder, "QualityCenterQTPAddinsInstaller.CouldntGenerateInstallerISS");
    }

    /**
     * Quality Center client installer
     * 
     */
    public static String QualityCenterClientInstaller_DescriptorImpl_DisplayName() {
        return holder.format("QualityCenterClientInstaller.DescriptorImpl.DisplayName");
    }

    /**
     * Quality Center client installer
     * 
     */
    public static Localizable _QualityCenterClientInstaller_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "QualityCenterClientInstaller.DescriptorImpl.DisplayName");
    }

    /**
     * Installation aborted
     * 
     */
    public static String QualityCenterClientInstaller_AbortedInstall() {
        return holder.format("QualityCenterClientInstaller.AbortedInstall");
    }

    /**
     * Installation aborted
     * 
     */
    public static Localizable _QualityCenterClientInstaller_AbortedInstall() {
        return new Localizable(holder, "QualityCenterClientInstaller.AbortedInstall");
    }

    /**
     * Installing {0}...
     * 
     */
    public static String QualityCenterClientInstaller_Installing(Object arg1) {
        return holder.format("QualityCenterClientInstaller.Installing", arg1);
    }

    /**
     * Installing {0}...
     * 
     */
    public static Localizable _QualityCenterClientInstaller_Installing(Object arg1) {
        return new Localizable(holder, "QualityCenterClientInstaller.Installing", arg1);
    }

}
