/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.qc;

import com.michelin.cio.hudson.plugins.qc.Messages;
import com.michelin.cio.hudson.plugins.qc.QualityCenter;
import com.michelin.cio.hudson.plugins.qc.client.QualityCenterClientInstallation;
import com.michelin.cio.hudson.plugins.qc.qtpaddins.QualityCenterQTPAddinsInstallation;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualityCenter
extends Builder {
    private static final String VB_SCRIPT_NAME = "runTestSet.vbs";
    private final String qcClientInstallationName;
    private final String qcQTPAddinInstallationName;
    private final String qcServerURL;
    private final String qcLogin;
    private final String qcPass;
    private final String qcDomain;
    private final String qcProject;
    private final String qcTSFolder;
    private final String qcTSName;
    private final String qcTSLogFile;
    private final String qcTimeOut;
    private String parsedQcTSLogFile;

    @DataBoundConstructor
    public QualityCenter(String qcClientInstallationName, String qcQTPAddinInstallationName, String qcServerURL, String qcLogin, String qcPass, String qcDomain, String qcProject, String qcTSFolder, String qcTSName, String qcTSLogFile, String qcTimeOut) {
        this.qcClientInstallationName = qcClientInstallationName;
        this.qcQTPAddinInstallationName = qcQTPAddinInstallationName;
        this.qcServerURL = qcServerURL;
        this.qcLogin = qcLogin;
        this.qcPass = qcPass;
        this.qcDomain = qcDomain;
        this.qcProject = qcProject;
        this.qcTSFolder = qcTSFolder;
        this.qcTSName = qcTSName;
        this.qcTSLogFile = qcTSLogFile;
        this.qcTimeOut = qcTimeOut;
    }

    public String getQcDomain() {
        return this.qcDomain;
    }

    public String getQcClientInstallationName() {
        return this.qcClientInstallationName;
    }

    public String getQcQTPAddinInstallationName() {
        return this.qcQTPAddinInstallationName;
    }

    public String getQcLogin() {
        return this.qcLogin;
    }

    public String getQcPass() {
        return this.qcPass;
    }

    public String getQcProject() {
        return this.qcProject;
    }

    public String getQcServerURL() {
        return this.qcServerURL;
    }

    public String getQcTSFolder() {
        return this.qcTSFolder;
    }

    public String getQcTSLogFile() {
        return this.qcTSLogFile;
    }

    public String getParsedQcTSLogFile() {
        return this.parsedQcTSLogFile;
    }

    public String getQcTSName() {
        return this.qcTSName;
    }

    public String getQcTimeOut() {
        return this.qcTimeOut;
    }

    public static String getVbScriptName() {
        return VB_SCRIPT_NAME;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public QualityCenterClientInstallation getQualityCenterClientInstallation() {
        for (QualityCenterClientInstallation installation : this.getDescriptor().getClientInstallations()) {
            if (this.qcClientInstallationName == null || !installation.getName().equals(this.qcClientInstallationName)) continue;
            return installation;
        }
        return null;
    }

    public QualityCenterQTPAddinsInstallation getQualityCenterQTPAddinInstallation() {
        for (QualityCenterQTPAddinsInstallation installation : this.getDescriptor().getQTPAddinsInstallations()) {
            if (this.qcQTPAddinInstallationName == null || !installation.getName().equals(this.qcQTPAddinInstallationName)) continue;
            return installation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        QualityCenterClientInstallation qcInstallation = this.getQualityCenterClientInstallation();
        if (qcInstallation == null) {
            listener.fatalError(Messages.QualityCenter_NoInstallationSet());
            return false;
        }
        if ((qcInstallation = qcInstallation.forNode(Computer.currentComputer().getNode(), (TaskListener)listener)) == null) {
            listener.fatalError(Messages.QualityCenter_NotAvailableOnThisOS());
            return false;
        }
        String qcDll = (qcInstallation = qcInstallation.forEnvironment(env)).getQCDll(launcher);
        if (qcDll == null) {
            listener.fatalError(Messages.QualityCenter_DllNotFound());
            return false;
        }
        QualityCenterQTPAddinsInstallation qcQTPInstallation = this.getQualityCenterQTPAddinInstallation();
        if (qcQTPInstallation != null) {
            qcQTPInstallation = qcQTPInstallation.forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
            qcQTPInstallation = qcQTPInstallation.forEnvironment(env);
        }
        FilePath projectWS = build.getWorkspace();
        URL vbsUrl = Hudson.getInstance().pluginManager.uberClassLoader.getResource(VB_SCRIPT_NAME);
        if (vbsUrl == null) {
            listener.fatalError(Messages.QualityCenter_VBSNotFound());
            return false;
        }
        FilePath vbScript = projectWS.child(VB_SCRIPT_NAME);
        vbScript.copyFrom(vbsUrl);
        try {
            String logFile = this.runVBScript(build, launcher, listener, vbScript);
            if (!projectWS.child(logFile).exists()) {
                listener.fatalError(Messages.QualityCenter_ReportNotGenerated());
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException ioe) {
            Util.displayIOException((IOException)ioe, (TaskListener)listener);
            boolean bl = false;
            return bl;
        }
        finally {
            vbScript.delete();
        }
        return true;
    }

    private void pushEnvVars(EnvVars env) {
        env.put("QC_DOMAIN", this.qcDomain);
        env.put("QC_PROJECT", this.qcProject);
        env.put("TS_FOLDER", this.qcTSFolder);
        env.put("TS_NAME", this.qcTSName);
    }

    private void removeEnvVars(EnvVars env) {
        env.remove((Object)"QC_DOMAIN");
        env.remove((Object)"QC_PROJECT");
        env.remove((Object)"TS_FOLDER");
        env.remove((Object)"TS_NAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runVBScript(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, FilePath file) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        VariableResolver varResolver = build.getBuildVariableResolver();
        PrintStream out = listener.getLogger();
        this.pushEnvVars(env);
        this.parsedQcTSLogFile = Util.replaceMacro((String)env.expand(this.qcTSLogFile), (VariableResolver)varResolver);
        args.add("cscript");
        args.add("/nologo");
        args.add((Object)file);
        args.add(Util.replaceMacro((String)env.expand(this.qcServerURL), (VariableResolver)varResolver));
        args.add(Util.replaceMacro((String)env.expand(this.qcLogin), (VariableResolver)varResolver));
        if (!StringUtils.isBlank((String)this.qcPass)) {
            args.addMasked(Util.replaceMacro((String)env.expand(this.qcPass), (VariableResolver)varResolver));
        } else {
            args.addMasked("\"\"");
        }
        args.add(Util.replaceMacro((String)env.expand(this.qcDomain), (VariableResolver)varResolver));
        args.add(Util.replaceMacro((String)env.expand(this.qcProject), (VariableResolver)varResolver));
        args.add(Util.replaceMacro((String)env.expand(this.qcTSFolder), (VariableResolver)varResolver));
        args.add(Util.replaceMacro((String)env.expand(this.qcTSName), (VariableResolver)varResolver));
        args.add(this.parsedQcTSLogFile);
        args.add(this.qcTimeOut);
        this.removeEnvVars(env);
        if (launcher.launch().cmds(args).stdout((OutputStream)out).pwd(file.getParent()).join() != 0) {
            listener.fatalError(Messages.QualityCenter_TSSchedulerFailed());
            FileInputStream is = new FileInputStream(this.parsedQcTSLogFile);
            InputStreamReader in = new InputStreamReader((InputStream)is, "UTF-16");
            try {
                IOUtils.copy((Reader)in, (Writer)new OutputStreamWriter(out));
            }
            finally {
                in.close();
                ((InputStream)is).close();
            }
            throw new AbortException();
        }
        return this.parsedQcTSLogFile;
    }
}

