/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.qc;

import com.michelin.cio.hudson.plugins.qc.Messages;
import com.michelin.cio.hudson.plugins.qc.QualityCenter;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Project;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.tasks.Recorder;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultAggregator;
import hudson.tasks.test.TestResultProjectAction;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualityCenterResultArchiver
extends Recorder
implements Serializable,
MatrixAggregatable {
    @DataBoundConstructor
    public QualityCenterResultArchiver() {
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        TestResultAction action;
        List builders = ((Project)build.getProject()).getBuilders();
        ArrayList<String> names = new ArrayList<String>();
        for (Builder builder : builders) {
            if (!(builder instanceof QualityCenter)) continue;
            names.add(((QualityCenter)builder).getParsedQcTSLogFile());
        }
        if (names.isEmpty()) {
            listener.getLogger().println(Messages.QualityCenterResultArchiver_NoBuilderSet());
            return true;
        }
        try {
            long buildTime = build.getTimestamp().getTimeInMillis();
            long nowMaster = System.currentTimeMillis();
            TestResult result = (TestResult)build.getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
            action = new TestResultAction(build, result, listener);
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                throw new AbortException("Result is empty");
            }
        }
        catch (AbortException e) {
            if (build.getResult() == Result.FAILURE) {
                return true;
            }
            listener.getLogger().println(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to archive QC reports"));
            build.setResult(Result.FAILURE);
            return true;
        }
        build.getActions().add(action);
        if (action.getResult().getFailCount() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new TestResultProjectAction(project);
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new TestResultAggregator(build, launcher, listener);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }
}

