/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.qc;

import com.michelin.cio.hudson.plugins.qc.Messages;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class QualityCenterUtils {
    public static FormValidation checkQcServerURL(String value) {
        return QualityCenterUtils.checkQcServerURL((String)value, (Boolean)false);
    }

    public static FormValidation checkQcServerURL(String value, Boolean acceptEmpty) {
        String page = "servlet/tdservlet/TDAPI_GeneralWebTreatment";
        if (StringUtils.isBlank((String)value)) {
            if (!acceptEmpty.booleanValue()) {
                return FormValidation.error((String)Messages.QualityCenter_ServerURLMustBeDefined());
            }
            return FormValidation.ok();
        }
        String url = value.lastIndexOf("/") == value.length() - 1 ? value + page : value + "/" + page;
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("HEAD");
            if (connection.getResponseCode() != 200) {
                return FormValidation.error((String)connection.getResponseMessage());
            }
        }
        catch (MalformedURLException ex) {
            return FormValidation.error((String)Messages.QualityCenter_MalformedServerURL());
        }
        catch (IOException ex) {
            return FormValidation.error((String)Messages.QualityCenter_ErrorOpeningServerConnection());
        }
        return FormValidation.ok();
    }

    public static FormValidation checkLocalPathToInstaller(String value, Boolean acceptEmpty) {
        if (StringUtils.isBlank((String)value)) {
            if (!acceptEmpty.booleanValue()) {
                return FormValidation.error((String)Messages.QualityCenter_PathMustBeDefined());
            }
            return FormValidation.ok();
        }
        File installer = new File(value);
        if (!installer.exists()) {
            return FormValidation.error((String)Messages.QualityCenterClientInstaller_CannotFindInstaller());
        }
        if (!installer.isFile()) {
            return FormValidation.error((String)Messages.QualityCenterClientInstaller_ShouldBeAFile());
        }
        return FormValidation.ok();
    }
}

