/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.qc.qtpaddins;

import com.michelin.cio.hudson.plugins.qc.Messages;
import com.michelin.cio.hudson.plugins.qc.qtpaddins.QualityCenterQTPAddinsInstaller;
import groovy.text.GStringTemplateEngine;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * Exception performing whole class analysis ignored.
 */
public class QualityCenterQTPAddinsInstaller
extends ToolInstaller {
    private static final String TEMPLATE_NAME = "installTemplate.iss";
    private static final String GENERATED_ISS_NAME = "setup.iss";
    private static final String REPORT_READER_EXE = "QTReport.exe";
    private static final String BIN_FOLDER = "bin";
    private final String version;
    private final String localPathToQTPAddin;
    private final boolean acceptLicense;

    @DataBoundConstructor
    public QualityCenterQTPAddinsInstaller(String version, String localPathToQTPAddin, boolean acceptLicense) {
        super(null);
        this.version = version;
        this.localPathToQTPAddin = localPathToQTPAddin;
        this.acceptLicense = acceptLicense;
    }

    public boolean isAcceptLicense() {
        return this.acceptLicense;
    }

    public String getLocalPathToQTPAddin() {
        return this.localPathToQTPAddin;
    }

    public String getVersion() {
        return this.version;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws InterruptedException, AbortException, IOException {
        FilePath installer;
        String instalIss;
        File f;
        FilePath expectedLocation = this.preferredLocation(tool, node);
        PrintStream out = log.getLogger();
        if (expectedLocation.child(".installedByHudson").exists() || expectedLocation.child("bin").child("QTReport.exe").exists()) {
            return expectedLocation;
        }
        expectedLocation.mkdirs();
        FilePath file = expectedLocation.child("setup.iss");
        if (!this.acceptLicense) {
            log.fatalError(Messages.QualityCenterQTPAddinsInstaller_AcceptLicense());
            throw new AbortException();
        }
        URL template = Hudson.getInstance().pluginManager.uberClassLoader.getResource("installTemplate.iss");
        try {
            f = new File(template.toURI());
        }
        catch (URISyntaxException e) {
            f = new File(template.getPath());
        }
        GStringTemplateEngine engine = new GStringTemplateEngine();
        QTPVersion currentVersion = QTPVersion.valueOf((String)("QTP" + this.version.replaceAll("\\.", "")));
        if (this.version == null) {
            log.fatalError(Messages.QualityCenterQTPAddinsInstaller_CouldntFindValidVersion());
            throw new AbortException();
        }
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("key", currentVersion.key);
        binding.put("path", expectedLocation.absolutize().getRemote());
        out.println(Messages.QualityCenterQTPAddinsInstaller_GeneratingInstallerISS());
        try {
            instalIss = engine.createTemplate(f).make(binding).toString();
        }
        catch (Exception e) {
            log.fatalError(Messages.QualityCenterQTPAddinsInstaller_CouldntGenerateInstallerISS());
            throw new AbortException();
        }
        file.write(instalIss, "ISO-8859-1");
        if (this.localPathToQTPAddin != null & this.localPathToQTPAddin.length() > 0) {
            FilePath installerOnMaster = new FilePath((VirtualChannel)Hudson.MasterComputer.localChannel, this.localPathToQTPAddin);
            if (!installerOnMaster.exists()) {
                log.fatalError(Messages.QualityCenterClientInstaller_CannotFindInstaller());
                throw new AbortException();
            }
            if (installerOnMaster.isDirectory()) {
                log.fatalError(Messages.QualityCenterClientInstaller_ShouldBeAFile());
                throw new AbortException();
            }
            installer = expectedLocation.child(installerOnMaster.getName());
            out.println(Messages.QualityCenterClientInstaller_CopyingFromMaster((Object)this.localPathToQTPAddin));
            installer.copyFrom(installerOnMaster);
        } else {
            URL installURL = new URL(currentVersion.url);
            URLConnection cnx = ProxyConfiguration.open((URL)installURL);
            installer = expectedLocation.child(installURL.getFile());
            out.println(Messages.QualityCenterClientInstaller_Downloading((Object)installURL));
            installer.copyFrom(cnx.getInputStream());
        }
        this.install(node.createLauncher(log), log, expectedLocation.absolutize().getRemote(), installer);
        installer.delete();
        file.delete();
        if (!expectedLocation.child("bin").child("QTReport.exe").exists()) {
            log.fatalError(Messages.QualityCenterQTPAddinsInstaller_CouldntFindExeAfterInstall((Object)"QTReport.exe"));
            throw new AbortException();
        }
        expectedLocation.child(".installedByHudson").touch(System.currentTimeMillis());
        return expectedLocation;
    }

    public void install(Launcher launcher, TaskListener log, String expectedLocation, FilePath install) throws IOException, InterruptedException {
        PrintStream out = log.getLogger();
        String installName = install.getName();
        FilePath absolutizedInstall = install.absolutize();
        out.println(Messages.QualityCenterClientInstaller_Installing((Object)installName));
        FilePath logFilePath = absolutizedInstall.getParent().child("setup.log");
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(absolutizedInstall.getRemote());
        args.add("/S");
        args.add("/v/qn");
        if (launcher.launch().cmds(args).stdout((OutputStream)out).pwd(expectedLocation).join() != 0) {
            log.fatalError(Messages.QualityCenterClientInstaller_AbortedInstall());
            out.println(logFilePath.readToString());
            throw new AbortException();
        }
        out.println(Messages.QualityCenterQTPAddinsInstaller_InstallationSuccessfull());
    }
}

