/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.qc;

import com.michelin.cio.hudson.plugins.qc.Messages;
import com.michelin.cio.hudson.plugins.qc.QualityCenter;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Project;
import hudson.model.Result;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultAggregator;
import hudson.tasks.test.TestResultProjectAction;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualityCenterResultArchiver
extends Recorder
implements Serializable,
MatrixAggregatable {
    @DataBoundConstructor
    public QualityCenterResultArchiver() {
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        TestResultAction action;
        List builders = ((Project)build.getProject()).getBuilders();
        final ArrayList<String> names = new ArrayList<String>();
        for (Builder builder : builders) {
            if (!(builder instanceof QualityCenter)) continue;
            names.add(((QualityCenter)builder).getParsedQcTSLogFile());
        }
        if (names.isEmpty()) {
            listener.getLogger().println(Messages.QualityCenterResultArchiver_NoBuilderSet());
            return true;
        }
        try {
            final long buildTime = build.getTimestamp().getTimeInMillis();
            final long nowMaster = System.currentTimeMillis();
            TestResult result = (TestResult)build.getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<TestResult>(){

                public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
                    long nowSlave = System.currentTimeMillis();
                    ArrayList<String> files = new ArrayList<String>();
                    DirectoryScanner ds = new DirectoryScanner();
                    ds.setBasedir(ws);
                    for (String name : names) {
                        File file = new File(ws, name);
                        if (!file.exists()) continue;
                        files.add(file.getName());
                    }
                    String[] objectArray = new String[files.size()];
                    files.toArray(objectArray);
                    ds.setIncludes(objectArray);
                    ds.scan();
                    if (ds.getIncludedFilesCount() == 0) {
                        throw new AbortException("Report not found");
                    }
                    return new TestResult(buildTime + (nowSlave - nowMaster), ds);
                }
            });
            action = new TestResultAction(build, result, listener);
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                throw new AbortException("Result is empty");
            }
        }
        catch (AbortException e) {
            if (build.getResult() == Result.FAILURE) {
                return true;
            }
            listener.getLogger().println(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to archive QC reports"));
            build.setResult(Result.FAILURE);
            return true;
        }
        build.getActions().add(action);
        if (action.getResult().getFailCount() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new TestResultProjectAction(project);
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new TestResultAggregator(build, launcher, listener);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return Messages.QualityCenterResultArchiver_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

