/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.qc.client;

import com.michelin.cio.hudson.plugins.qc.Messages;
import com.michelin.cio.hudson.plugins.qc.QualityCenter;
import com.michelin.cio.hudson.plugins.qc.client.QualityCenterClientInstaller;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.EnvironmentSpecific;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.slaves.SlaveComputer;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualityCenterClientInstallation
extends ToolInstallation
implements NodeSpecific<QualityCenterClientInstallation>,
EnvironmentSpecific<QualityCenterClientInstallation> {
    public QualityCenterClientInstallation(String name, String qcHome) {
        super(name, qcHome, Collections.emptyList());
    }

    @DataBoundConstructor
    public QualityCenterClientInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public QualityCenterClientInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        Computer computer = node.toComputer();
        if (computer instanceof SlaveComputer && !((SlaveComputer)computer).isUnix().booleanValue()) {
            computer = null;
            return new QualityCenterClientInstallation(this.getName(), this.translateFor(node, log));
        }
        if (Functions.isWindows()) {
            return new QualityCenterClientInstallation(this.getName(), this.translateFor(node, log));
        }
        return null;
    }

    public QualityCenterClientInstallation forEnvironment(EnvVars environment) {
        return new QualityCenterClientInstallation(this.getName(), environment.expand(this.getHome()));
    }

    public String getQCDll(Launcher launcher) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new Callable<String, IOException>(){

            public String call() throws IOException {
                File qcDll = QualityCenterClientInstallation.this.getDllFile();
                if (qcDll.exists()) {
                    return qcDll.getPath();
                }
                return null;
            }
        });
    }

    private File getDllFile() {
        String home = Util.replaceMacro((String)this.getHome(), (Map)EnvVars.masterEnvVars);
        return new File(home, "OTAClient.dll");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<QualityCenterClientInstallation> {
        public String getDisplayName() {
            return Messages.QualityCenterInstallation_DisplayName();
        }

        public List<QualityCenterClientInstaller> getDefaultInstallers() {
            return Collections.singletonList(new QualityCenterClientInstaller(null, null));
        }

        public QualityCenterClientInstallation[] getInstallations() {
            return ((QualityCenter.DescriptorImpl)Hudson.getInstance().getDescriptorByType(QualityCenter.DescriptorImpl.class)).getClientInstallations();
        }

        public void setInstallations(QualityCenterClientInstallation ... installations) {
            ((QualityCenter.DescriptorImpl)Hudson.getInstance().getDescriptorByType(QualityCenter.DescriptorImpl.class)).setClientInstallations(installations);
        }

        public FormValidation doCheckHome(@QueryParameter File value) {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            if (value.getPath().equals("")) {
                return FormValidation.ok();
            }
            if (!value.isDirectory()) {
                return FormValidation.error((String)Messages.QualityCenterInstallation_NotADirectory());
            }
            File dll = new File(value, "OTAClient.dll");
            File dll2 = new File(value, "MERCURY INTERACTIVE\\Quality CenterOTAClient.dll");
            if (!dll.exists() && !dll2.exists()) {
                return FormValidation.error((String)Messages.QualityCenterInstallation_NotQualityCenterDir());
            }
            return FormValidation.ok();
        }
    }
}

