/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.qc.client;

import com.michelin.cio.hudson.plugins.qc.Messages;
import com.michelin.cio.hudson.plugins.qc.QualityCenterUtils;
import com.michelin.cio.hudson.plugins.qc.client.QualityCenterClientInstallation;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class QualityCenterClientInstaller
extends ToolInstaller {
    private final String qcServerURL;
    private final String localPathToQCClient;
    public static final String INSTALLER_PATH_ON_SERVER = "PlugIns/ClientSideInstallation/";
    public static final String DLL_PATH_ON_NODE = "MERCURY INTERACTIVE\\Quality Center";
    public static final String INSTALLLER_FILE_NAME = "QCClient.msi";
    public static final String DLL_NAME = "OTAClient.dll";

    @DataBoundConstructor
    public QualityCenterClientInstaller(String qcServerURL, String localPathToQCClient) {
        super(null);
        this.qcServerURL = qcServerURL;
        this.localPathToQCClient = localPathToQCClient;
    }

    public String getLocalPathToQCClient() {
        return this.localPathToQCClient;
    }

    public String getQcServerURL() {
        return this.qcServerURL;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        FilePath expectedLocation = this.preferredLocation(tool, node);
        PrintStream out = log.getLogger();
        FilePath qcFolder = expectedLocation.child(DLL_PATH_ON_NODE);
        if (expectedLocation.child(".installedByHudson").exists() || expectedLocation.child(DLL_NAME).exists()) {
            return expectedLocation;
        }
        if (qcFolder.child(".installedByHudson").exists() || qcFolder.child(DLL_NAME).exists()) {
            return qcFolder;
        }
        expectedLocation.mkdirs();
        FilePath file = expectedLocation.child(INSTALLLER_FILE_NAME);
        if (this.localPathToQCClient != null & this.localPathToQCClient.length() > 0) {
            FilePath installerOnMaster = new FilePath((VirtualChannel)Hudson.MasterComputer.localChannel, this.localPathToQCClient);
            if (!installerOnMaster.exists()) {
                log.fatalError(Messages.QualityCenterClientInstaller_CannotFindInstaller());
                throw new AbortException();
            }
            if (installerOnMaster.isDirectory()) {
                log.fatalError(Messages.QualityCenterClientInstaller_ShouldBeAFile());
                throw new AbortException();
            }
            out.println(Messages.QualityCenterClientInstaller_CopyingFromMaster(this.localPathToQCClient));
            file.copyFrom(installerOnMaster);
        } else {
            String url = this.qcServerURL.lastIndexOf("/") == this.qcServerURL.length() - 1 ? this.qcServerURL + INSTALLER_PATH_ON_SERVER + INSTALLLER_FILE_NAME : this.qcServerURL + "/" + INSTALLER_PATH_ON_SERVER + INSTALLLER_FILE_NAME;
            URL installURL = new URL(url);
            out.println(Messages.QualityCenterClientInstaller_Downloading(installURL));
            file.copyFrom(installURL);
        }
        this.install(node.createLauncher(log), log, expectedLocation.absolutize().getRemote(), file);
        file.delete();
        if (!qcFolder.child(DLL_NAME).exists()) {
            log.fatalError(Messages.QualityCenterClientInstaller_CouldntFindDllAfterInstall(DLL_NAME));
            throw new AbortException();
        }
        qcFolder.child(".installedByHudson").touch(System.currentTimeMillis());
        return qcFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(Launcher launcher, TaskListener log, String expectedLocation, FilePath qcBundle) throws IOException, InterruptedException {
        PrintStream out = log.getLogger();
        String qcBundleName = qcBundle.getName();
        String qcBundlePath = qcBundle.absolutize().getRemote();
        out.println(Messages.QualityCenterClientInstaller_Installing(qcBundleName));
        String logFile = qcBundlePath + ".install.log";
        StringBuilder cmd = new StringBuilder();
        cmd.append('\"').append(qcBundlePath).append('\"');
        cmd.append(" /qn /norestart TARGETDIR=");
        cmd.append('\"').append(expectedLocation).append('\"');
        cmd.append(" /l ");
        cmd.append('\"').append(logFile).append('\"');
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"cmd.exe", "/C"}).addQuoted(cmd.toString());
        if (launcher.launch().cmds(args).stdout((OutputStream)out).pwd(expectedLocation).join() != 0) {
            log.fatalError(Messages.QualityCenterClientInstaller_AbortedInstall());
            FileInputStream is = new FileInputStream(logFile);
            InputStreamReader in = new InputStreamReader((InputStream)is, "UTF-16");
            try {
                IOUtils.copy((Reader)in, (Writer)new OutputStreamWriter(out));
            }
            finally {
                in.close();
                ((InputStream)is).close();
            }
            throw new AbortException();
        }
        out.println(Messages.QualityCenterClientInstaller_InstallationSuccessfull());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends ToolInstallerDescriptor<QualityCenterClientInstaller> {
        public String getDisplayName() {
            return Messages.QualityCenterClientInstaller_DescriptorImpl_DisplayName();
        }

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == QualityCenterClientInstallation.class;
        }

        public FormValidation doCheckQcServerURL(@QueryParameter String value) {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            return QualityCenterUtils.checkQcServerURL(value, true);
        }

        public FormValidation doCheckLocalPathToQCClient(@QueryParameter String value) {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            return QualityCenterUtils.checkLocalPathToInstaller(value, true);
        }
    }
}

