/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.qc.qtpaddins;

import com.michelin.cio.hudson.plugins.qc.Messages;
import com.michelin.cio.hudson.plugins.qc.QualityCenterUtils;
import com.michelin.cio.hudson.plugins.qc.client.QualityCenterClientInstallation;
import groovy.text.GStringTemplateEngine;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class QualityCenterQTPAddinsInstaller
extends ToolInstaller {
    private static final String TEMPLATE_NAME = "installTemplate.iss";
    private static final String GENERATED_ISS_NAME = "setup.iss";
    private static final String REPORT_READER_EXE = "QTReport.exe";
    private static final String BIN_FOLDER = "bin";
    private final String version;
    private final String localPathToQTPAddin;
    private final boolean acceptLicense;

    @DataBoundConstructor
    public QualityCenterQTPAddinsInstaller(String version, String localPathToQTPAddin, boolean acceptLicense) {
        super(null);
        this.version = version;
        this.localPathToQTPAddin = localPathToQTPAddin;
        this.acceptLicense = acceptLicense;
    }

    public boolean isAcceptLicense() {
        return this.acceptLicense;
    }

    public String getLocalPathToQTPAddin() {
        return this.localPathToQTPAddin;
    }

    public String getVersion() {
        return this.version;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws InterruptedException, AbortException, IOException {
        FilePath installer;
        String instalIss;
        File f;
        FilePath expectedLocation = this.preferredLocation(tool, node);
        PrintStream out = log.getLogger();
        if (expectedLocation.child(".installedByHudson").exists() || expectedLocation.child(BIN_FOLDER).child(REPORT_READER_EXE).exists()) {
            return expectedLocation;
        }
        expectedLocation.mkdirs();
        FilePath file = expectedLocation.child(GENERATED_ISS_NAME);
        if (!this.acceptLicense) {
            log.fatalError(Messages.QualityCenterQTPAddinsInstaller_AcceptLicense());
            throw new AbortException();
        }
        URL template = Hudson.getInstance().pluginManager.uberClassLoader.getResource(TEMPLATE_NAME);
        try {
            f = new File(template.toURI());
        }
        catch (URISyntaxException e) {
            f = new File(template.getPath());
        }
        GStringTemplateEngine engine = new GStringTemplateEngine();
        QTPVersion currentVersion = QTPVersion.valueOf("QTP" + this.version.replaceAll("\\.", ""));
        if (this.version == null) {
            log.fatalError(Messages.QualityCenterQTPAddinsInstaller_CouldntFindValidVersion());
            throw new AbortException();
        }
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("key", currentVersion.key);
        binding.put("path", expectedLocation.absolutize().getRemote());
        out.println(Messages.QualityCenterQTPAddinsInstaller_GeneratingInstallerISS());
        try {
            instalIss = engine.createTemplate(f).make(binding).toString();
        }
        catch (Exception e) {
            log.fatalError(Messages.QualityCenterQTPAddinsInstaller_CouldntGenerateInstallerISS());
            throw new AbortException();
        }
        file.write(instalIss, "ISO-8859-1");
        if (this.localPathToQTPAddin != null & this.localPathToQTPAddin.length() > 0) {
            FilePath installerOnMaster = new FilePath((VirtualChannel)Hudson.MasterComputer.localChannel, this.localPathToQTPAddin);
            if (!installerOnMaster.exists()) {
                log.fatalError(Messages.QualityCenterClientInstaller_CannotFindInstaller());
                throw new AbortException();
            }
            if (installerOnMaster.isDirectory()) {
                log.fatalError(Messages.QualityCenterClientInstaller_ShouldBeAFile());
                throw new AbortException();
            }
            installer = expectedLocation.child(installerOnMaster.getName());
            out.println(Messages.QualityCenterClientInstaller_CopyingFromMaster(this.localPathToQTPAddin));
            installer.copyFrom(installerOnMaster);
        } else {
            URL installURL = new URL(currentVersion.url);
            URLConnection cnx = ProxyConfiguration.open((URL)installURL);
            installer = expectedLocation.child(installURL.getFile());
            out.println(Messages.QualityCenterClientInstaller_Downloading(installURL));
            installer.copyFrom(cnx.getInputStream());
        }
        this.install(node.createLauncher(log), log, expectedLocation.absolutize().getRemote(), installer);
        installer.delete();
        file.delete();
        if (!expectedLocation.child(BIN_FOLDER).child(REPORT_READER_EXE).exists()) {
            log.fatalError(Messages.QualityCenterQTPAddinsInstaller_CouldntFindExeAfterInstall(REPORT_READER_EXE));
            throw new AbortException();
        }
        expectedLocation.child(".installedByHudson").touch(System.currentTimeMillis());
        return expectedLocation;
    }

    public void install(Launcher launcher, TaskListener log, String expectedLocation, FilePath install) throws IOException, InterruptedException {
        PrintStream out = log.getLogger();
        String installName = install.getName();
        FilePath absolutizedInstall = install.absolutize();
        out.println(Messages.QualityCenterClientInstaller_Installing(installName));
        FilePath logFilePath = absolutizedInstall.getParent().child("setup.log");
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(absolutizedInstall.getRemote());
        args.add("/S");
        args.add("/v/qn");
        if (launcher.launch().cmds(args).stdout((OutputStream)out).pwd(expectedLocation).join() != 0) {
            log.fatalError(Messages.QualityCenterClientInstaller_AbortedInstall());
            out.println(logFilePath.readToString());
            throw new AbortException();
        }
        out.println(Messages.QualityCenterQTPAddinsInstaller_InstallationSuccessfull());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QTPVersion {
        QTP90("9.0", "http://update.external.hp.com/qualitycenter/qc90/mictools/qtp/TDPlugInsSetup.exe", "B7677BB4-7E32-4430-90AE-E37EE6FED55E"),
        QTP91("9.1", "http://update.external.hp.com/qualitycenter/qc90/mictools/qtp/qtp_9_1/TDPlugInsSetup.exe", "B7677BB4-7E32-4430-90AE-E37EE6FED55E"),
        QTP92("9.2", "http://update.external.hp.com/qualitycenter/qc90/mictools/qtp/qtp_sp/TDPlugInsSetup.exe", "051B35E4-5986-4AD5-9470-693558044699");

        public final String version;
        public final String url;
        public final String key;

        private QTPVersion(String version, String url, String key) {
            this.version = version;
            this.url = url;
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String getUrl() {
            return this.url;
        }

        public String getVersion() {
            return this.version;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends ToolInstallerDescriptor<QualityCenterQTPAddinsInstaller> {
        public String getDisplayName() {
            return Messages.QualityCenterQTPAddinsInstaller_DescriptorImpl_DisplayName();
        }

        public QTPVersion[] getAddinsArray() throws MalformedURLException {
            return QTPVersion.values();
        }

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == QualityCenterClientInstallation.class;
        }

        public FormValidation doCheckLocalPathToQTPAddin(@QueryParameter String value) {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            return QualityCenterUtils.checkLocalPathToInstaller(value, true);
        }
    }
}

