/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.radbuilder;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.radbuilder.RADInstallation;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tools.ToolInstallation;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.Map;
import net.sf.json.JSONObject;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAD
extends Builder {
    public static final String RAD_WORKSPACE_ENV_VAR = "workspace";
    public static final String RAD_WORKSAPCE_METADATA_FOLDER = ".metadata";
    private final boolean activateProjectWorkspaceVar;
    private final String buildFile;
    private final boolean deleteRadWorkspaceContent;
    private final boolean deleteRadWorkspaceMetadata;
    private final String properties;
    private final String radInstallationName;
    private final String radWorkspace;
    private final String targets;

    @DataBoundConstructor
    public RAD(boolean activateProjectWorkspaceVar, String buildFile, boolean deleteRadWorkspaceContent, boolean deleteRadWorkspaceMetadata, String properties, String radInstallationName, String radWorkspace, String targets) {
        this.activateProjectWorkspaceVar = activateProjectWorkspaceVar;
        this.buildFile = Util.fixEmptyAndTrim((String)buildFile);
        this.deleteRadWorkspaceContent = deleteRadWorkspaceContent;
        this.deleteRadWorkspaceMetadata = deleteRadWorkspaceMetadata;
        this.properties = Util.fixEmptyAndTrim((String)properties);
        this.radInstallationName = radInstallationName;
        this.radWorkspace = Util.fixEmptyAndTrim((String)radWorkspace);
        this.targets = targets;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public RADInstallation getRadInstallation() {
        for (RADInstallation installation : this.getDescriptor().getInstallations()) {
            if (this.getRadInstallationName() == null || !installation.getName().equals(this.getRadInstallationName())) continue;
            return installation;
        }
        return null;
    }

    public boolean getActivateProjectWorkspaceVar() {
        return this.activateProjectWorkspaceVar;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public boolean getDeleteRadWorkspaceContent() {
        return this.deleteRadWorkspaceContent;
    }

    public boolean getDeleteRadWorkspaceMetadata() {
        return this.deleteRadWorkspaceMetadata;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getRadInstallationName() {
        return this.radInstallationName;
    }

    public String getRadWorkspace() {
        return this.radWorkspace;
    }

    public String getTargets() {
        return this.targets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath metadataFilePath;
        FilePath radWorkspaceFilePath;
        AbstractProject project = build.getProject();
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        VariableResolver varResolver = build.getBuildVariableResolver();
        RADInstallation radInstallation = this.getRadInstallation();
        if (radInstallation == null) {
            listener.fatalError(ResourceBundleHolder.get(RAD.class).format("NoInstallationSet", new Object[0]));
            return false;
        }
        radInstallation = radInstallation.forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
        String runAntExecutable = (radInstallation = radInstallation.forEnvironment(env)).getRunAntExecutable(launcher);
        if (runAntExecutable == null) {
            listener.fatalError(ResourceBundleHolder.get(RAD.class).format("NoRunAntExecutable", new Object[]{radInstallation.getName()}));
            return false;
        }
        args.add(runAntExecutable);
        if (this.getRadWorkspace() != null) {
            radWorkspaceFilePath = project.getWorkspace().child(this.getRadWorkspace());
            if (radWorkspaceFilePath.getName().equals(project.getWorkspace().getName())) {
                listener.fatalError("The RAD workspace is the same as the project's workspace: It must not.");
                return false;
            }
        } else {
            radWorkspaceFilePath = project.getWorkspace().child(project.getName() + "-rad-workspace");
        }
        if (!radWorkspaceFilePath.exists()) {
            radWorkspaceFilePath.mkdirs();
        }
        String hudsonWorkspaceEnvVar = (String)env.get((Object)"WORKSPACE");
        env.remove((Object)"WORKSPACE");
        if (this.getActivateProjectWorkspaceVar()) {
            env.put((Object)"PROJECT_WORKSPACE", (Object)hudsonWorkspaceEnvVar.replaceAll("\\\\", "/"));
        }
        if (!launcher.isUnix()) {
            env.put((Object)RAD_WORKSPACE_ENV_VAR, (Object)radWorkspaceFilePath.toURI().getPath().substring(1));
        } else {
            env.put((Object)RAD_WORKSPACE_ENV_VAR, (Object)radWorkspaceFilePath.getName());
        }
        if (this.getDeleteRadWorkspaceContent()) {
            radWorkspaceFilePath.deleteContents();
        } else if (this.getDeleteRadWorkspaceMetadata() && (metadataFilePath = radWorkspaceFilePath.child(RAD_WORKSAPCE_METADATA_FOLDER)).exists()) {
            metadataFilePath.deleteRecursive();
        }
        String lBuildFile = this.getBuildFile() == null ? "build.xml" : Util.replaceMacro((String)env.expand(this.getBuildFile()), (VariableResolver)varResolver);
        if (project.getWorkspace() == null) {
            listener.fatalError("Unable to find project's workspace");
            return false;
        }
        FilePath buildFilePath = project.getWorkspace().child(lBuildFile);
        if (!buildFilePath.exists()) {
            listener.fatalError("Unable to find build script at " + buildFilePath);
            return false;
        }
        args.add(new String[]{"-buildfile", buildFilePath.getName()});
        args.addKeyValuePairsFromPropertyString("-D", env.expand(this.getProperties()), varResolver);
        String lTargets = Util.replaceMacro((String)env.expand(this.getTargets()), (VariableResolver)varResolver);
        args.addTokenized(lTargets.replaceAll("[\t\r\n]+", " "));
        if (!launcher.isUnix()) {
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
            args = new ArgumentListBuilder().add(new String[]{"cmd.exe", "/C"}).addQuoted(args.toStringWithQuote());
        }
        long startTime = System.currentTimeMillis();
        try {
            int r = launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(buildFilePath.getParent()).join();
            boolean bl = r == 0;
            return bl;
        }
        catch (IOException ioe) {
            Util.displayIOException((IOException)ioe, (TaskListener)listener);
            String errorMessage = ResourceBundleHolder.get(RAD.class).format("ExecutionFailed", new Object[0]);
            if (radInstallation == null && System.currentTimeMillis() - startTime < 1000L) {
                errorMessage = this.getDescriptor().getInstallations() == null ? errorMessage + ResourceBundleHolder.get(RAD.class).format("NoInstallationAtAll", new Object[0]) : errorMessage + ResourceBundleHolder.get(RAD.class).format("NoInstallationSet", new Object[0]);
            }
            listener.fatalError(errorMessage);
            boolean bl = false;
            return bl;
        }
        finally {
            env.remove((Object)RAD_WORKSPACE_ENV_VAR);
            env.put((Object)"WORKSPACE", (Object)hudsonWorkspaceEnvVar);
            env.remove((Object)"PROJECT_WORKSPACE");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private volatile RADInstallation[] installations = new RADInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        protected DescriptorImpl(Class<? extends RAD> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return ResourceBundleHolder.get(RAD.class).format("DisplayName", new Object[0]);
        }

        public RADInstallation[] getInstallations() {
            return this.installations;
        }

        public RADInstallation.DescriptorImpl getToolDescriptor() {
            return (RADInstallation.DescriptorImpl)((Object)ToolInstallation.all().get(RADInstallation.DescriptorImpl.class));
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return this.getInstallations() != null && this.getInstallations().length > 0;
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)req.bindJSON(RAD.class, formData);
        }

        public void setInstallations(RADInstallation ... installations) {
            this.installations = installations;
            this.save();
        }
    }
}

