/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.radbuilder;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.radbuilder.RAD;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RADInstallation
extends ToolInstallation
implements NodeSpecific<RADInstallation>,
EnvironmentSpecific<RADInstallation> {
    @DataBoundConstructor
    public RADInstallation(String name, String home) {
        super(name, RADInstallation.removeTrailingBackslash(home), Collections.EMPTY_LIST);
    }

    public RADInstallation forEnvironment(EnvVars environment) {
        return new RADInstallation(this.getName(), environment.expand(this.getHome()));
    }

    public RADInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new RADInstallation(this.getName(), this.translateFor(node, log));
    }

    public String getRunAntExecutable(Launcher launcher) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new Callable<String, IOException>(){

            public String call() throws IOException {
                File runAntFile = RADInstallation.this.getRunAntFile("bin");
                if (runAntFile.exists()) {
                    return runAntFile.getPath();
                }
                runAntFile = RADInstallation.this.getRunAntFile("eclipse/bin");
                if (runAntFile.exists()) {
                    return runAntFile.getPath();
                }
                return null;
            }
        });
    }

    private File getRunAntFile(String binFolder) {
        String runAntFileName = "runAnt.sh";
        if (Hudson.isWindows()) {
            runAntFileName = "runAnt.bat";
        }
        return new File(Util.replaceMacro((String)this.getHome(), (Map)EnvVars.masterEnvVars), binFolder + "/" + runAntFileName);
    }

    private static String removeTrailingBackslash(String s) {
        return StringUtils.removeEnd((String)StringUtils.removeEnd((String)s, (String)"/"), (String)"\\");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends ToolDescriptor<RADInstallation> {
        public String getDisplayName() {
            return ResourceBundleHolder.get(RAD.class).format("DisplayName", new Object[0]);
        }

        public RADInstallation[] getInstallations() {
            return ((RAD.DescriptorImpl)Hudson.getInstance().getDescriptorByType(RAD.DescriptorImpl.class)).getInstallations();
        }

        public void setInstallations(RADInstallation ... installations) {
            ((RAD.DescriptorImpl)Hudson.getInstance().getDescriptorByType(RAD.DescriptorImpl.class)).setInstallations(installations);
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.setInstallations(req.bindJSONToList(RADInstallation.class, json.get("rad")).toArray(new RADInstallation[0]));
            return true;
        }

        public FormValidation doCheckHome(@QueryParameter File value) {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (value.getPath().equals("")) {
                return FormValidation.error((String)ResourceBundleHolder.get(RADInstallation.class).format("InstallationFolderMustBeSet", new Object[0]));
            }
            if (!value.isDirectory()) {
                return FormValidation.error((String)ResourceBundleHolder.get(RADInstallation.class).format("NotAFolder", new Object[]{value}));
            }
            if (Hudson.isWindows()) {
                boolean noRADRunAntBat = false;
                boolean noBURunAntBat = false;
                File runAntFile = new File(value, "bin/runAnt.bat");
                if (!runAntFile.exists()) {
                    noRADRunAntBat = true;
                    runAntFile = new File(value, "eclipse/bin/runAnt.bat");
                    if (!runAntFile.exists()) {
                        noBURunAntBat = true;
                    }
                }
                if (noBURunAntBat || noBURunAntBat && noRADRunAntBat) {
                    return FormValidation.error((String)ResourceBundleHolder.get(RADInstallation.class).format("NotARADInstallationFolder", new Object[]{value}));
                }
            } else {
                boolean noRADRunAntSh = false;
                boolean noBURunAntSh = false;
                File runAntFile = new File(value, "bin/runAnt.sh");
                if (!runAntFile.exists()) {
                    noRADRunAntSh = true;
                    runAntFile = new File(value, "eclipse/bin/runAnt.sh");
                    if (!runAntFile.exists()) {
                        noBURunAntSh = true;
                    }
                }
                if (noBURunAntSh || noBURunAntSh && noRADRunAntSh) {
                    return FormValidation.error((String)ResourceBundleHolder.get(RADInstallation.class).format("NotARADInstallationFolder", new Object[]{value}));
                }
            }
            return FormValidation.ok();
        }
    }
}

