/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.RadiatorView;
import hudson.model.Result;
import hudson.model.Run;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class RadiatorView
extends ListView {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RadiatorView(String name) {
        super(name);
    }

    public static int getSize(Collection<Job> jobs) {
        int count = 0;
        for (Job job : jobs) {
            Result result = RadiatorView.getResult((Job)job);
            if (result != Result.SUCCESS) continue;
            ++count;
        }
        count += (jobs.size() - count) * 6;
        double perRow = Math.ceil(Math.sqrt(count));
        int size = (int)perRow;
        return size;
    }

    public static Collection<Job> sortJobs(Collection<Job> jobs) {
        TreeSet<Job> set = new TreeSet<Job>((Comparator<Job>)new JobComparator(null));
        if (jobs != null) {
            set.addAll(jobs);
        }
        return set;
    }

    public static boolean isBuilding(Job job) {
        return !job.getLastBuild().isLogUpdated();
    }

    public static Result getResult(Job job) {
        Run lastBuild;
        for (lastBuild = job.getLastBuild(); lastBuild != null && (lastBuild.hasntStartedYet() || lastBuild.isBuilding()); lastBuild = lastBuild.getPreviousBuild()) {
        }
        if (lastBuild != null) {
            return lastBuild.getResult();
        }
        return Result.NOT_BUILT;
    }
}

