/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Util;
import hudson.model.HealthReport;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.ViewDescriptor;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadiatorView
extends ListView {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RadiatorView(String name) {
        super(name);
    }

    public static int getSize(Collection<Job> jobs) {
        int count = 0;
        for (Job job : jobs) {
            Result result = RadiatorView.getResult(job);
            if (result != Result.SUCCESS) continue;
            ++count;
        }
        count += (jobs.size() - count) * 6;
        double perRow = Math.ceil(Math.sqrt(count));
        int size = (int)perRow;
        return size;
    }

    public static Collection<Job> sortJobs(Collection<Job> jobs) {
        TreeSet<Job> set = new TreeSet<Job>(new JobComparator());
        if (jobs != null) {
            set.addAll(jobs);
        }
        return set;
    }

    public static boolean isBuilding(Job job) {
        return !job.getLastBuild().isLogUpdated();
    }

    public static Result getResult(Job job) {
        Run lastBuild;
        for (lastBuild = job.getLastBuild(); lastBuild != null && (lastBuild.hasntStartedYet() || lastBuild.isBuilding()); lastBuild = lastBuild.getPreviousBuild()) {
        }
        if (lastBuild != null) {
            return lastBuild.getResult();
        }
        return Result.NOT_BUILT;
    }

    public static final class DescriptorImpl
    extends ViewDescriptor {
        public String getDisplayName() {
            return "Radiator";
        }

        public void doCheckIncludeRegex(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String v = Util.fixEmpty((String)this.request.getParameter("value"));
                    if (v != null) {
                        try {
                            Pattern.compile(v);
                        }
                        catch (PatternSyntaxException pse) {
                            this.error(pse.getMessage());
                        }
                    }
                    this.ok();
                }
            }.process();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JobComparator
    implements Comparator<Job> {
        private JobComparator() {
        }

        @Override
        public int compare(Job o1, Job o2) {
            int health;
            System.out.println("Comparing " + o1 + " to " + o2);
            Result r1 = RadiatorView.getResult(o1);
            Result r2 = RadiatorView.getResult(o2);
            if (r1 != null && r2 != null) {
                if (r1.isBetterThan(r2)) {
                    return 1;
                }
                if (r1.isWorseThan(r2)) {
                    return -1;
                }
            }
            HealthReport h1 = o1.getBuildHealth();
            HealthReport h2 = o2.getBuildHealth();
            if (h1 != null && h2 != null && (health = h1.compareTo(h2)) != 0) {
                return health;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }
}

