/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Functions;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.RadiatorView;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.ViewEntry;
import hudson.model.ViewEntryColors;
import hudson.tasks.test.AbstractTestResultAction;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ViewEntry {
    private final RadiatorView radiatorView;
    private Job<?, ?> job;
    private String backgroundColor;
    private String color;
    private Boolean broken;
    private Boolean building = false;
    private Boolean queued = false;
    private Integer queueNumber;

    public ViewEntry(RadiatorView radiatorView, Job<?, ?> job) {
        this.radiatorView = radiatorView;
        this.job = job;
        this.findStatus();
    }

    public Job<?, ?> getJob() {
        return this.job;
    }

    public String getName() {
        return this.job.getName();
    }

    public Boolean getQueued() {
        return this.job.isInQueue();
    }

    public Integer getQueueNumber() {
        return (Integer)this.radiatorView.placeInQueue.get(this.job.getQueueItem());
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getColor() {
        return this.color;
    }

    public Boolean getBroken() {
        return this.broken;
    }

    public Boolean getBuilding() {
        return this.building;
    }

    public String getUrl() {
        return this.job.getUrl() + "lastBuild";
    }

    public List<Run<?, ?>> getBuildsInProgress() {
        ArrayList runs = new ArrayList();
        Run run = this.job.getLastBuild();
        if (run.isBuilding()) {
            runs.add(run);
        }
        for (Run prev = run.getPreviousBuildInProgress(); prev != null; prev = prev.getPreviousBuildInProgress()) {
            runs.add(prev);
        }
        return runs;
    }

    public int getTestCount() {
        Run run = this.job.getLastSuccessfulBuild();
        if (run != null) {
            AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
            return tests != null ? tests.getTotalCount() : 0;
        }
        return 0;
    }

    public int getFailCount() {
        Run run = this.job.getLastSuccessfulBuild();
        if (run != null) {
            AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
            return tests != null ? tests.getFailCount() : 0;
        }
        return 0;
    }

    public int getSuccessCount() {
        return this.getTestCount() - this.getFailCount();
    }

    public String getDiff() {
        Run previous;
        Run run = this.job.getLastSuccessfulBuild();
        if (run != null && (previous = this.getLastSuccessfulFrom(run)) != null) {
            AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
            AbstractTestResultAction prevTests = (AbstractTestResultAction)previous.getAction(AbstractTestResultAction.class);
            if (tests != null && prevTests != null) {
                int prevSuccess;
                int currentSuccess = tests.getTotalCount() - tests.getFailCount();
                int diff = currentSuccess - (prevSuccess = prevTests.getTotalCount() - prevTests.getFailCount());
                if (diff != 0) {
                    return Functions.getDiffString((int)diff);
                }
                return "";
            }
        }
        return "";
    }

    private Run<?, ?> getLastSuccessfulFrom(Run<?, ?> run) {
        Run r;
        for (r = run.getPreviousBuild(); r != null && (r.isBuilding() || r.getResult() == null || r.getResult().isWorseThan(Result.UNSTABLE)); r = r.getPreviousBuild()) {
        }
        return r;
    }

    public String getCulprit() {
        Run run = this.job.getLastBuild();
        String culprit = " - ";
        if (run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)run;
            Iterator it = build.getCulprits().iterator();
            while (it.hasNext()) {
                culprit = ((User)it.next()).getFullName();
            }
        }
        return culprit;
    }

    public String getDiffColor() {
        String diff = this.getDiff().trim();
        if (diff.length() > 0 && !Functions.getDiffString((int)0).equals(diff)) {
            if (diff.startsWith("-")) {
                return "#FF0000";
            }
            return "#00FF00";
        }
        return "#FFFFFF";
    }

    public String getSuccessPercentage() {
        if (this.getTestCount() > 0) {
            Double perc = (double)this.getSuccessCount() / ((double)this.getTestCount() * 1.0);
            return NumberFormat.getPercentInstance().format(perc);
        }
        return "";
    }

    private void findStatus() {
        Result result = RadiatorView.getResult((Job)this.job);
        if (result.ordinal == Result.NOT_BUILT.ordinal) {
            this.backgroundColor = this.getColors().getOtherBG();
            this.color = this.getColors().getOtherFG();
        } else if (result.ordinal == Result.SUCCESS.ordinal) {
            this.backgroundColor = this.getColors().getOkBG();
            this.color = this.getColors().getOkFG();
            this.broken = false;
        } else if (result.ordinal == Result.UNSTABLE.ordinal) {
            this.backgroundColor = this.getColors().getFailedBG();
            this.color = this.getColors().getFailedFG();
            this.broken = false;
        } else {
            this.backgroundColor = this.getColors().getBrokenBG();
            this.color = this.getColors().getBrokenFG();
            this.broken = true;
        }
        switch (1.$SwitchMap$hudson$model$BallColor[this.job.getIconColor().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.building = true;
            }
        }
        this.building = false;
    }

    private ViewEntryColors getColors() {
        return this.radiatorView.getColors();
    }
}

