/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.model.Descriptor;
import hudson.model.EntryComparator;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.ViewEntry;
import hudson.model.ViewEntryColors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class RadiatorView
extends ListView {
    private transient Collection<ViewEntry> entries;
    transient Map<Queue.Item, Integer> placeInQueue = new HashMap();
    transient ViewEntryColors colors;
    private Boolean showStable = false;
    private Boolean showStableDetail = false;
    private Boolean highVis = true;

    @DataBoundConstructor
    public RadiatorView(String name, Boolean showStable, Boolean showStableDetail, Boolean highVis) {
        super(name);
        this.showStable = showStable;
        this.showStableDetail = showStableDetail;
        this.highVis = highVis;
    }

    public ViewEntryColors getColors() {
        if (this.colors == null) {
            this.colors = ViewEntryColors.DEFAULT;
        }
        return this.colors;
    }

    public Collection<ViewEntry> sortPassing(Collection<Job> jobs) {
        return this.sort(jobs, true);
    }

    private Collection<ViewEntry> sort(Collection<Job> jobs, boolean successful) {
        this.placeInQueue = new HashMap();
        int j = 1;
        for (Queue.Item i : Hudson.getInstance().getQueue().getItems()) {
            this.placeInQueue.put(i, j++);
        }
        if (jobs != null) {
            TreeSet<ViewEntry> ents = new TreeSet<ViewEntry>((Comparator<ViewEntry>)new EntryComparator());
            for (Job job : jobs) {
                if (RadiatorView.getResult((Job)job).isBetterOrEqualTo(Result.SUCCESS) != successful) continue;
                ents.add(new ViewEntry(this, job));
            }
            this.entries = ents;
            return this.entries;
        }
        return Collections.emptyList();
    }

    protected void submit(StaplerRequest req) throws ServletException, Descriptor.FormException {
        super.submit(req);
        this.showStable = Boolean.parseBoolean(req.getParameter("showStable"));
        this.showStableDetail = Boolean.parseBoolean(req.getParameter("showStableDetail"));
        this.highVis = Boolean.parseBoolean(req.getParameter("highVis"));
    }

    public Boolean getShowStable() {
        return this.showStable;
    }

    public Boolean getShowStableDetail() {
        return this.showStableDetail;
    }

    public Boolean getHighVis() {
        return this.highVis;
    }

    public Collection<ViewEntry> sortFailing(Collection<Job> jobs) {
        return this.sort(jobs, false);
    }

    public Collection<Collection<ViewEntry>> toRows(Collection<ViewEntry> jobs, Boolean failingJobs) {
        int jobsPerRow = 1;
        if (failingJobs.booleanValue()) {
            if (jobs.size() > 3) {
                jobsPerRow = 2;
            }
            if (jobs.size() > 9) {
                jobsPerRow = 3;
            }
            if (jobs.size() > 15) {
                jobsPerRow = 4;
            }
        } else {
            jobsPerRow = (int)Math.floor(Math.sqrt(jobs.size()) * 1.5);
        }
        ArrayList<Collection<ViewEntry>> rows = new ArrayList<Collection<ViewEntry>>();
        ArrayList<ViewEntry> current = null;
        int i = 0;
        for (ViewEntry job : jobs) {
            if (i == 0) {
                current = new ArrayList<ViewEntry>();
                rows.add(current);
            }
            current.add(job);
            if (++i < jobsPerRow) continue;
            i = 0;
        }
        return rows;
    }

    public static Result getResult(Job job) {
        Run lastBuild;
        for (lastBuild = job.getLastBuild(); lastBuild != null && (lastBuild.hasntStartedYet() || lastBuild.isBuilding() || lastBuild.isLogUpdated()); lastBuild = lastBuild.getPreviousBuild()) {
        }
        if (lastBuild != null) {
            return lastBuild.getResult();
        }
        return Result.NOT_BUILT;
    }
}

