/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rake;

import hudson.plugins.rake.RubyInstallation;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static String[] RUBY_EXECUTABLES = new String[]{"ruby", "jruby"};
    private static FilenameFilter rakeFilter = new FilenameFilter(){
        Pattern rakePattern = Pattern.compile("rake\\-([\\d.]+).gemspec");

        public boolean accept(File path, String file) {
            return this.rakePattern.matcher(file).matches();
        }
    };

    public static File getExecutable(String path) {
        String execName = Util.isWindows() ? "rake.bat" : "rake";
        File parent = null;
        parent = Util.isJruby(path) ? new File(path) : new File(path).getParentFile().getParentFile();
        return new File(parent, "bin/" + execName);
    }

    public static boolean isWindows() {
        String name = System.getProperty("os.name");
        if (name != null) {
            return name.contains("Windows");
        }
        return File.separatorChar == '\\';
    }

    public static boolean isJruby(String path) {
        String execName = Util.isWindows() ? "jruby.bat" : "jruby";
        return new File(path, "bin/" + execName).exists();
    }

    public static boolean hasGemsInstalled(String path) {
        File gems = Util.getGemsDir(path);
        return gems != null && gems.exists() && gems.isDirectory();
    }

    public static File getGemsDir(String path) {
        File gems = null;
        if (path.startsWith("$")) {
            path = System.getenv(path.substring(1));
        }
        gems = Util.isJruby(path) ? new File(path + "/lib/ruby/gems/1.8") : new File(path + "/gems/1.8");
        return gems;
    }

    public static boolean isRakeInstalled(File gemsDir) {
        File specPath = new File(gemsDir, "specifications");
        return specPath.exists() && specPath.listFiles(rakeFilter) != null;
    }

    public static Collection<File> getRubyInstallations() throws IOException {
        String systemPath = System.getenv("PATH");
        if (systemPath == null) {
            systemPath = System.getenv("path");
        }
        ArrayList<File> rubyVersions = new ArrayList<File>();
        if (systemPath != null) {
            LinkedHashSet<String> candidates = new LinkedHashSet<String>(Arrays.asList(systemPath.split(File.pathSeparator)));
            for (String path : candidates) {
                for (String ruby : RUBY_EXECUTABLES) {
                    File gemsDir;
                    File rubyExec;
                    File file = rubyExec = Util.isWindows() ? new File(path, ruby + ".exe") : new File(path, ruby);
                    if (!rubyExec.isFile() || rubyVersions.contains(rubyExec.getCanonicalFile().getParentFile())) continue;
                    File parent = rubyExec.getCanonicalFile().getParentFile();
                    if (Util.isJruby(parent.getParent())) {
                        parent = parent.getParentFile();
                    }
                    if ((gemsDir = Util.getGemsDir(parent.getAbsolutePath())) == null || !Util.isRakeInstalled(gemsDir)) continue;
                    rubyVersions.add(parent);
                }
            }
        }
        return rubyVersions;
    }

    public static RubyInstallation[] getCanonicalRubies(RubyInstallation[] currentInstallations) {
        try {
            Collection<File> rubies = Util.getRubyInstallations();
            ArrayList<RubyInstallation> currentList = new ArrayList<RubyInstallation>();
            for (File ruby : rubies) {
                currentList.add(new RubyInstallation(ruby.getName(), ruby.getAbsolutePath()));
            }
            for (RubyInstallation current : currentList) {
                File cur = new File(current.getPath());
                if (rubies.contains(cur.getCanonicalFile())) continue;
                currentList.add(current);
            }
            return currentList.toArray(new RubyInstallation[0]);
        }
        catch (IOException e) {
            hudson.Util.displayIOException((IOException)e, null);
            return new RubyInstallation[0];
        }
    }

    public static boolean isAlreadyInstalled(RubyInstallation[] current, String path) {
        try {
            for (RubyInstallation ruby : current) {
                if (!new File(ruby.getPath()).getCanonicalPath().equals(new File(path).getCanonicalPath())) continue;
                return true;
            }
        }
        catch (IOException e) {
            hudson.Util.displayIOException((IOException)e, null);
        }
        return false;
    }
}

