/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rake;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.plugins.rake.RubyInstallation;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rake
extends Builder {
    public static final RakeDescriptor DESCRIPTOR = new RakeDescriptor();
    private final String rakeInstallation;
    private final String rakeFile;
    private final String rakeLibDir;
    private final String rakeWorkingDir;
    private final String tasks;
    private final boolean silent;

    @DataBoundConstructor
    public Rake(String rakeInstallation, String rakeFile, String tasks, String rakeLibDir, String rakeWorkingDir, boolean silent) {
        this.rakeInstallation = rakeInstallation;
        this.rakeFile = rakeFile;
        this.tasks = tasks;
        this.rakeLibDir = rakeLibDir;
        this.rakeWorkingDir = rakeWorkingDir;
        this.silent = silent;
    }

    private RubyInstallation getRake() {
        for (RubyInstallation rake : this.getDescriptor().getInstallations()) {
            if (this.rakeInstallation == null || !rake.getName().equals(this.rakeInstallation)) continue;
            return rake;
        }
        return null;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        Project proj = (Project)build.getProject();
        ArgumentListBuilder args = new ArgumentListBuilder();
        String normalizedTasks = this.tasks.replaceAll("[\t\r\n]+", " ");
        RubyInstallation rake = this.getRake();
        if (rake != null) {
            File exec = rake.getExecutable();
            if (!exec.exists()) {
                listener.fatalError(exec + " doesn't exist");
                return false;
            }
            args.add(exec.getPath());
        } else {
            args.add(launcher.isUnix() ? "rake" : "rake.bat");
        }
        if (this.rakeFile != null && this.rakeFile.length() > 0) {
            args.add(new String[]{"--rakefile", this.rakeFile});
        }
        if (this.rakeLibDir != null && this.rakeLibDir.length() > 0) {
            args.add(new String[]{"--libdir", this.rakeLibDir});
        }
        if (this.silent) {
            args.add("--silent");
        }
        FilePath workingDir = proj.getModuleRoot();
        if (this.rakeWorkingDir != null && this.rakeWorkingDir.length() > 0) {
            workingDir = new FilePath(proj.getModuleRoot(), this.rakeWorkingDir);
        }
        args.addTokenized(normalizedTasks);
        try {
            int r = launcher.launch(args.toCommandArray(), build.getEnvVars(), (OutputStream)listener.getLogger(), workingDir).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("rake execution failed"));
            return false;
        }
    }

    public RakeDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public String getRakeInstallation() {
        return this.rakeInstallation;
    }

    public String getRakeFile() {
        return this.rakeFile;
    }

    public String getRakeLibDir() {
        return this.rakeLibDir;
    }

    public String getTasks() {
        return this.tasks;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public String getRakeWorkingDir() {
        return this.rakeWorkingDir;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RakeDescriptor
    extends Descriptor<Builder> {
        private volatile RubyInstallation[] installations = new RubyInstallation[0];

        private RakeDescriptor() {
            super(Rake.class);
            this.load();
        }

        public synchronized void load() {
            super.load();
            this.installations = hudson.plugins.rake.Util.getCanonicalRubies(this.installations);
        }

        public String getDisplayName() {
            return "Invoke Rake";
        }

        public Rake newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Rake)((Object)req.bindJSON(this.clazz, formData));
        }

        public String getHelpFile() {
            return "/plugin/rake/help.html";
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            this.installations = req.bindParametersToList(RubyInstallation.class, "rake.").toArray(new RubyInstallation[0]);
            this.save();
            return true;
        }

        public RubyInstallation[] getInstallations() {
            return this.installations;
        }

        public void doCheckRubyInstallation(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, true){

                public void check() throws IOException, ServletException {
                    File f = this.getFileParameter("value");
                    if (!f.isDirectory()) {
                        this.error(f + " is not a directory");
                        return;
                    }
                    if (!hudson.plugins.rake.Util.hasGemsInstalled(f.getAbsolutePath())) {
                        this.error("It seems that ruby gems is not installed");
                        return;
                    }
                    if (!hudson.plugins.rake.Util.isRakeInstalled(hudson.plugins.rake.Util.getGemsDir(f.getAbsolutePath()))) {
                        this.error("It seems that rake is not installed");
                        return;
                    }
                    this.ok();
                }
            }.process();
        }
    }
}

