/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rake;

import hudson.plugins.rake.RubyInstallation;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Util {
    private static final String[] RUBY_EXECUTABLES = new String[]{"ruby", "jruby"};
    private static FilenameFilter rakeFilter = new /* Unavailable Anonymous Inner Class!! */;
    private static FilenameFilter gemDirFilter = new /* Unavailable Anonymous Inner Class!! */;

    public static File getExecutable(String path) {
        String execName = Util.isWindows() ? "rake.bat" : "rake";
        File parent = Util.isJruby((String)path) ? new File(path) : new File(path).getParentFile().getParentFile();
        return new File(parent, "bin/" + execName);
    }

    public static boolean isWindows() {
        String name = System.getProperty("os.name");
        return name != null ? name.contains("Windows") : File.separatorChar == '\\';
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").endsWith("Linux");
    }

    public static boolean isMac() {
        return System.getProperty("os.name").equalsIgnoreCase("Mac OS X");
    }

    public static boolean isJruby(String path) {
        String execName = Util.isWindows() ? "jruby.bat" : "jruby";
        return new File(path, "bin/" + execName).exists();
    }

    public static boolean hasGemsInstalled(String path) {
        File[] gems;
        for (File gem : gems = Util.getGemsDir((String)path)) {
            if (gem == null || !gem.exists() || !gem.isDirectory()) continue;
            return true;
        }
        return false;
    }

    public static File[] getGemsDir(String path) {
        File gemsBaseFile;
        if (path.startsWith("$")) {
            path = System.getenv(path.substring(1));
        }
        File[] gemDirsFiltered = new File[]{};
        File[] arr$ = new File[]{new File(path + "/lib/ruby/gems"), new File(path + "/gems")};
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (gemsBaseFile = arr$[i$]).exists() && (gemDirsFiltered = gemsBaseFile.listFiles(gemDirFilter)) != null && gemDirsFiltered.length > 0); ++i$) {
        }
        return gemDirsFiltered;
    }

    public static boolean isRakeInstalled(File ... gemsDirArray) {
        for (File gemsDir : gemsDirArray) {
            File specPath = new File(gemsDir, "specifications");
            if (!specPath.exists() || specPath.listFiles(rakeFilter) == null) continue;
            return true;
        }
        return false;
    }

    public static Collection<File> getRubyInstallations() throws IOException {
        String systemPath = System.getenv("PATH");
        if (systemPath == null) {
            systemPath = System.getenv("path");
        }
        LinkedHashSet<File> rubyVersions = new LinkedHashSet<File>();
        if (systemPath != null) {
            LinkedHashSet<String> candidates = new LinkedHashSet<String>(Arrays.asList(systemPath.split(File.pathSeparator)));
            for (String path : candidates) {
                for (String ruby : RUBY_EXECUTABLES) {
                    File rubyExec = Util.getExecutableWithExceptions((String)path, (String)ruby);
                    if (!rubyExec.isFile() || rubyVersions.contains(rubyExec.getCanonicalFile().getParentFile())) continue;
                    File parent = rubyExec.getCanonicalFile().getParentFile();
                    File[] gemsDir = Util.getGemsDir((String)parent.getCanonicalPath());
                    if (!Util.isRakeInstalled((File[])gemsDir) && (Util.isMac() || Util.isJruby((String)parent.getParent()))) {
                        parent = parent.getParentFile();
                        gemsDir = Util.getGemsDir((String)parent.getAbsolutePath());
                    }
                    if (gemsDir == null || !Util.isRakeInstalled((File[])gemsDir)) continue;
                    rubyVersions.add(parent);
                }
            }
        }
        return rubyVersions;
    }

    public static RubyInstallation[] getCanonicalRubies(RubyInstallation[] currentInstallations) {
        try {
            Collection rubies = Util.getRubyInstallations();
            LinkedHashSet<RubyInstallation> currentList = new LinkedHashSet<RubyInstallation>(Arrays.asList(currentInstallations));
            block2: for (File ruby : rubies) {
                for (RubyInstallation current : currentList) {
                    if (!current.getCanonicalExecutable().equals(Util.getExecutable((String)ruby.getCanonicalPath()).getCanonicalFile())) continue;
                    continue block2;
                }
                currentList.add(new RubyInstallation(ruby.getName(), ruby.getCanonicalPath()));
            }
            return currentList.toArray(new RubyInstallation[currentList.size()]);
        }
        catch (IOException e) {
            hudson.Util.displayIOException((IOException)e, null);
            return new RubyInstallation[0];
        }
    }

    public static boolean isAlreadyInstalled(RubyInstallation[] current, String path) {
        try {
            for (RubyInstallation ruby : current) {
                if (!new File(ruby.getPath()).getCanonicalPath().equals(new File(path).getCanonicalPath())) continue;
                return true;
            }
        }
        catch (IOException e) {
            hudson.Util.displayIOException((IOException)e, null);
        }
        return false;
    }

    private static File getExecutableWithExceptions(String path, String exec) throws IOException {
        File rubyExec;
        File file = rubyExec = Util.isWindows() ? new File(path, exec + ".exe") : new File(path, exec);
        if (Util.isLinux() && rubyExec.exists() && rubyExec.getAbsolutePath().equals("/usr/bin/ruby")) {
            rubyExec = new File("/usr/lib/ruby/ruby");
        }
        return rubyExec;
    }
}

