/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rake;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.rake.Rake;
import hudson.plugins.rake.RubyInstallation;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rake
extends Builder {
    public static final RakeDescriptor DESCRIPTOR = new RakeDescriptor(null);
    private final String rakeInstallation;
    private final String rakeFile;
    private final String rakeLibDir;
    private final String rakeWorkingDir;
    private final String tasks;
    private final boolean silent;

    @DataBoundConstructor
    public Rake(String rakeInstallation, String rakeFile, String tasks, String rakeLibDir, String rakeWorkingDir, boolean silent) {
        this.rakeInstallation = rakeInstallation;
        this.rakeFile = rakeFile;
        this.tasks = tasks;
        this.rakeLibDir = rakeLibDir;
        this.rakeWorkingDir = rakeWorkingDir;
        this.silent = silent;
    }

    private RubyInstallation getRake() {
        for (RubyInstallation rake : this.getDescriptor().getInstallations()) {
            if (this.rakeInstallation == null || !rake.getName().equals(this.rakeInstallation)) continue;
            return rake;
        }
        return null;
    }

    private Launcher getLastBuiltLauncher(AbstractBuild build, Launcher launcher, BuildListener listener) {
        AbstractProject project = build.getProject();
        Node lastBuiltOn = project.getLastBuiltOn();
        Launcher lastBuiltLauncher = launcher;
        if (lastBuiltOn != null) {
            lastBuiltLauncher = lastBuiltOn.createLauncher((TaskListener)listener);
        }
        return lastBuiltLauncher;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        String normalizedTasks = this.tasks.replaceAll("[\t\r\n]+", " ");
        Launcher lastBuiltLauncher = this.getLastBuiltLauncher(build, launcher, listener);
        RubyInstallation rake = this.getRake();
        if (rake != null) {
            File exec = rake.getExecutable();
            if (!exec.exists()) {
                listener.fatalError(exec + " doesn't exist");
                return false;
            }
            args.add(exec.getPath());
        } else {
            args.add(lastBuiltLauncher.isUnix() ? "rake" : "rake.bat");
        }
        if (this.rakeFile != null && this.rakeFile.length() > 0) {
            args.add(new String[]{"--rakefile", this.rakeFile});
        }
        if (this.rakeLibDir != null && this.rakeLibDir.length() > 0) {
            args.add(new String[]{"--libdir", this.rakeLibDir});
        }
        if (this.silent) {
            args.add("--silent");
        }
        FilePath workingDir = build.getModuleRoot();
        if (this.rakeWorkingDir != null && this.rakeWorkingDir.length() > 0) {
            workingDir = new FilePath(build.getModuleRoot(), this.rakeWorkingDir);
        }
        args.addTokenized(normalizedTasks);
        try {
            int r = lastBuiltLauncher.launch().cmds(args).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((TaskListener)listener).pwd(workingDir).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("rake execution failed"));
            return false;
        }
    }

    public RakeDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public String getRakeInstallation() {
        return this.rakeInstallation;
    }

    public String getRakeFile() {
        return this.rakeFile;
    }

    public String getRakeLibDir() {
        return this.rakeLibDir;
    }

    public String getTasks() {
        return this.tasks;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public String getRakeWorkingDir() {
        return this.rakeWorkingDir;
    }
}

