/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rake;

import hudson.FilePath;
import hudson.plugins.rake.RubyInstallation;
import hudson.plugins.rake.Rvm;
import hudson.plugins.rake.RvmUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
class RvmUtil {
    private static FileFilter rakeFilter = new RakeSpecFilter(null);

    RvmUtil() {
    }

    public static Rvm getDefaultRvm() {
        String rvmPath;
        String userHome = System.getProperty("user.home");
        Rvm rvm = null;
        if (userHome != null && new File(rvmPath = userHome + File.separator + ".rvm").exists()) {
            rvm = new Rvm(rvmPath);
        }
        return rvm;
    }

    public static RubyInstallation[] getRvmRubies(Rvm rvm) {
        LinkedHashSet<RubyInstallation> rubies = new LinkedHashSet<RubyInstallation>();
        try {
            FilePath rubiesPath = new FilePath(new File(rvm.getPath(), "rubies"));
            FilePath gemsPath = new FilePath(new File(rvm.getPath(), "gems"));
            if (rubiesPath.exists() && gemsPath.exists()) {
                for (FilePath candidate : rubiesPath.list()) {
                    String name = candidate.getName();
                    RvmFilenameFilter filter = new RvmFilenameFilter(name);
                    List gems = gemsPath.list((FileFilter)filter);
                    for (FilePath gemCandidate : gems) {
                        List specs;
                        FilePath specifications = gemCandidate.child("specifications");
                        if (!specifications.exists() || (specs = specifications.list(rakeFilter)) == null || specs.size() <= 0) continue;
                        RubyInstallation ruby = new RubyInstallation(gemCandidate.getName(), new File(candidate.toURI()).getCanonicalPath());
                        ruby.setGemHome(new File(gemCandidate.toURI()).getCanonicalPath());
                        ruby.setGemPath(RvmUtil.buildGemPath((String)ruby.getGemHome(), (Collection)gems));
                        rubies.add(ruby);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rubies.toArray(new RubyInstallation[rubies.size()]);
    }

    private static String buildGemPath(String currentGem, Collection<FilePath> candidateGems) throws InterruptedException, IOException {
        StringBuilder path = new StringBuilder(currentGem);
        for (FilePath gem : candidateGems) {
            File gemFile = new File(gem.toURI());
            if (!gemFile.getCanonicalPath().startsWith(currentGem + "@") || !gem.child("specifications").exists()) continue;
            path.append(File.pathSeparator).append(gemFile.getCanonicalPath());
        }
        return path.toString();
    }
}

