/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rake;

import hudson.plugins.rake.Util;
import java.io.File;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public final class RubyInstallation {
    private final String name;
    private final String path;
    private String gemHome;
    private String gemPath;

    @DataBoundConstructor
    public RubyInstallation(String name, String path) {
        this.name = name;
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getGemHome() {
        return this.gemHome;
    }

    public void setGemHome(String gemHome) {
        this.gemHome = gemHome;
    }

    public String getGemPath() {
        return this.gemPath;
    }

    public void setGemPath(String gemPath) {
        this.gemPath = gemPath;
    }

    public File getExecutable() {
        return this.getGemHome() != null ? Util.getExecutable(this.getPath(), this.getGemHome()) : Util.getExecutable(this.getPath());
    }

    public File getCanonicalExecutable() throws IOException {
        return Util.getExecutable(this.getPath()).getCanonicalFile();
    }

    public String toString() {
        return "\nN " + this.getName() + "\n P " + this.getPath() + "\n GH " + this.getGemHome() + "\n GP " + this.getGemPath() + "\n EXEC " + this.getExecutable();
    }
}

