/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.rake;

import hudson.FilePath;
import hudson.plugins.rake.RubyInstallation;
import hudson.plugins.rake.Rvm;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RvmUtil {
    private static FileFilter rakeFilter = new RakeSpecFilter();

    RvmUtil() {
    }

    public static Rvm getDefaultRvm() {
        String rvmPath;
        String userHome = System.getProperty("user.home");
        Rvm rvm = null;
        if (userHome != null && new File(rvmPath = userHome + File.separator + ".rvm").exists()) {
            rvm = new Rvm(rvmPath);
        }
        return rvm;
    }

    public static RubyInstallation[] getRvmRubies(Rvm rvm) {
        LinkedHashSet<RubyInstallation> rubies = new LinkedHashSet<RubyInstallation>();
        try {
            FilePath rubiesPath = new FilePath(new File(rvm.getPath(), "rubies"));
            FilePath gemsPath = new FilePath(new File(rvm.getPath(), "gems"));
            if (rubiesPath.exists() && gemsPath.exists()) {
                for (FilePath candidate : rubiesPath.list()) {
                    String name = candidate.getName();
                    RvmFilenameFilter filter = new RvmFilenameFilter(name);
                    List gems = gemsPath.list((FileFilter)filter);
                    FilePath global = RvmUtil.getGlobal(name, gemsPath);
                    for (FilePath gemCandidate : gems) {
                        List specs;
                        FilePath specifications = RvmUtil.getSpecifications(gemCandidate, global);
                        if (specifications == null || (specs = specifications.list(rakeFilter)) == null || specs.size() <= 0) continue;
                        RubyInstallation ruby = new RubyInstallation(gemCandidate.getName(), new File(candidate.toURI()).getCanonicalPath());
                        ruby.setGemHome(new File(gemCandidate.toURI()).getCanonicalPath());
                        ruby.setGemPath(RvmUtil.buildGemPath(ruby.getGemHome(), global, gems));
                        rubies.add(ruby);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rubies.toArray(new RubyInstallation[rubies.size()]);
    }

    private static String buildGemPath(String currentGem, FilePath global, Collection<FilePath> candidateGems) throws InterruptedException, IOException {
        StringBuilder path = new StringBuilder();
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        paths.add(currentGem);
        for (FilePath gem : candidateGems) {
            File gemFile = new File(gem.toURI());
            String canonicalPath = gemFile.getCanonicalPath();
            if (!canonicalPath.startsWith(currentGem + "@") || !gem.child("specifications").exists()) continue;
            paths.add(canonicalPath);
        }
        if (global != null && global.child("specifications").exists()) {
            File globalFile = new File(global.toURI());
            paths.add(globalFile.getCanonicalPath());
        }
        for (String canonical : paths) {
            path.append(File.pathSeparator).append(canonical);
        }
        return path.toString();
    }

    private static FilePath getGlobal(String name, FilePath gemsPath) throws InterruptedException, IOException {
        RvmGlobalFilter globalFilter = new RvmGlobalFilter(name);
        List globalGems = gemsPath.list((FileFilter)globalFilter);
        FilePath global = null;
        if (!globalGems.isEmpty()) {
            global = (FilePath)globalGems.get(0);
        }
        return global;
    }

    private static FilePath getSpecifications(FilePath candidate, FilePath global) throws InterruptedException, IOException {
        FilePath specification = candidate.child("specifications");
        if (specification.exists()) {
            return specification;
        }
        if (global != null && global.exists() && global.child("specifications").exists()) {
            return global.child("specifications");
        }
        return null;
    }

    private static class RakeSpecFilter
    implements FileFilter,
    Serializable {
        private final Pattern rakePattern = Pattern.compile("rake\\-([\\d.]+).gemspec");

        private RakeSpecFilter() {
        }

        public boolean accept(File pathname) {
            return this.rakePattern.matcher(pathname.getName()).matches();
        }
    }

    private static class RvmGlobalFilter
    implements FileFilter,
    Serializable {
        private final String name;

        public RvmGlobalFilter(String name) {
            this.name = name;
        }

        public boolean accept(File pathname) {
            return pathname.getName().startsWith(this.name) && pathname.getName().endsWith("@global");
        }
    }

    private static class RvmFilenameFilter
    implements FileFilter,
    Serializable {
        private final String name;

        public RvmFilenameFilter(String name) {
            this.name = name;
        }

        public boolean accept(File pathname) {
            return pathname.getName().startsWith(this.name) && !pathname.getName().endsWith("@");
        }
    }
}

