/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.redmine;

import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.plugins.redmine.RedmineLinkAnnotator;
import hudson.plugins.redmine.RedmineProjectProperty;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedmineLinkAnnotator
extends ChangeLogAnnotator {
    static final LinkMarkup[] MARKUPS = new LinkMarkup[]{new LinkMarkup("(?:#|refs |references |IssueID |fixes |closes )NUM", "issues/show/$1"), new LinkMarkup("((?:[A-Z][a-z]+){2,})|wiki:ANYWORD", "wiki/$1$2")};

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        RedmineProjectProperty rpp = (RedmineProjectProperty)build.getProject().getProperty(RedmineProjectProperty.class);
        if (rpp == null || rpp.redmineWebsite == null) {
            return;
        }
        String url = rpp.redmineWebsite;
        for (LinkMarkup markup : MARKUPS) {
            markup.process(text, url);
        }
    }
}

