/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.redmine;

import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.plugins.redmine.RedmineProjectProperty;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedmineLinkAnnotator
extends ChangeLogAnnotator {
    static final LinkMarkup[] MARKUPS = new LinkMarkup[]{new LinkMarkup("(?:#|refs |references |IssueID |fixes |closes )NUM", "issues/show/$1"), new LinkMarkup("((?:[A-Z][a-z]+){2,})|wiki:ANYWORD", "wiki/$1$2")};

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        RedmineProjectProperty rpp = (RedmineProjectProperty)build.getProject().getProperty(RedmineProjectProperty.class);
        if (rpp == null || rpp.redmineWebsite == null) {
            return;
        }
        String url = rpp.redmineWebsite;
        for (LinkMarkup markup : MARKUPS) {
            markup.process(text, url);
        }
    }

    static final class LinkMarkup {
        private final Pattern pattern;
        private final String href;
        private static final Pattern NUM_PATTERN = Pattern.compile("NUM");
        private static final Pattern ANYWORD_PATTERN = Pattern.compile("ANYWORD");

        LinkMarkup(String pattern, String href) {
            pattern = NUM_PATTERN.matcher(pattern).replaceAll("([\\\\d|,| |&amp;|#]+)");
            pattern = ANYWORD_PATTERN.matcher(pattern).replaceAll("((?:\\\\w|[._-])+)");
            this.pattern = Pattern.compile(pattern);
            this.href = href;
        }

        void process(MarkupText text, String url) {
            for (MarkupText.SubText st : text.findTokens(this.pattern)) {
                String[] message = st.getText().split(" ", 2);
                if (message.length > 1) {
                    String[] nums = message[1].split(",|&amp;| ");
                    String splitValue = ",";
                    if (message[1].indexOf("&amp;") != -1) {
                        splitValue = "&amp;";
                    } else if (message[1].indexOf("#") != -1) {
                        splitValue = "#";
                    } else if (message[1].indexOf(" ") != -1) {
                        splitValue = " ";
                    }
                    if (nums.length > 1) {
                        int startpos = 0;
                        int endpos = message[0].length() + nums[0].length() + 1;
                        nums[0] = nums[0].replace("#", "");
                        st.addMarkup(startpos, endpos, "<a href='" + url + "issues/show/" + nums[0] + "'>", "</a>");
                        endpos = startpos = endpos + splitValue.length();
                        for (int i = 1; i < nums.length; ++i) {
                            endpos += nums[i].length();
                            if (i != 1) {
                                endpos += splitValue.length();
                            }
                            if (endpos >= st.getText().length()) {
                                endpos = st.getText().length();
                            }
                            if (StringUtils.isNotBlank((String)nums[i])) {
                                nums[i] = nums[i].replace("#", "");
                                st.addMarkup(startpos, endpos, "<a href='" + url + "issues/show/" + nums[i].trim() + "'>", "</a>");
                            }
                            startpos = endpos + splitValue.length();
                        }
                        continue;
                    }
                    st.surroundWith("<a href='" + url + this.href + "'>", "</a>");
                    continue;
                }
                st.surroundWith("<a href='" + url + this.href + "'>", "</a>");
            }
        }
    }
}

