/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.redmine;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.redmine.RedmineLinkAction;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedmineProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    public final String redmineWebsite;
    public final String projectName;
    public final Boolean redmineVersion;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RedmineProjectProperty(String redmineWebsite, String projectName, Boolean redmineVersion) {
        if (StringUtils.isBlank((String)redmineWebsite)) {
            redmineWebsite = null;
        } else if (!redmineWebsite.endsWith("/")) {
            redmineWebsite = redmineWebsite + '/';
        }
        this.redmineWebsite = redmineWebsite;
        this.projectName = projectName;
        this.redmineVersion = redmineVersion;
    }

    public Action getJobAction(AbstractProject<?, ?> job) {
        return new RedmineLinkAction(this);
    }

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private transient String redmineWebsite;

        public DescriptorImpl() {
            super(RedmineProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public String getDisplayName() {
            return "Associated Redmine website";
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            try {
                String redmineWebSite = req.getParameter("redmine.redmineWebsite");
                String projectName = req.getParameter("redmine.projectName");
                String redmineVersion = req.getParameter("redmine.version");
                Boolean version = false;
                if (StringUtils.isNotBlank((String)redmineVersion) && redmineVersion.equals("on")) {
                    version = true;
                }
                return new RedmineProjectProperty(redmineWebSite, projectName, version);
            }
            catch (IllegalArgumentException e) {
                throw new Descriptor.FormException("redmine.redmineWebsite", "redmine.redmineWebSite");
            }
        }
    }
}

